<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order Planning Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/index.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/1.1.2/css/bootstrap-multiselect.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/1.1.2/js/bootstrap-multiselect.min.js"></script>
    <style>
        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }

        .table th, .table td {
            width: 70px !important;
            font-size: 0.75rem;
            padding: 0.4rem !important;
        }
        .progress { height: 10px; background-color: #e9ecef; }
        .bg-purple { background-color: #a855f7 !important; color: #fff; }
        #monthRangePicker { font-size: 0.8rem; padding: 0.25rem 0.5rem; }
        .filter-toggle {
            background: none;
            border: none;
            cursor: pointer;
            padding: 2px;
            font-size: 12px;
            color: #444;
            transition: color 0.2s;
        }
        .filter-toggle:hover, .filter-toggle:focus {
            color: #007bff;
            outline: none;
        }
        .dropdown-filter {
            position: relative;
            display: inline-block;
            margin-left: 6px;
        }
        .checkbox-dropdown-content {
            display: none;
            position: absolute;
            top: 100%;
            left: -20px;
            z-index: 100;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 6px;
            box-shadow: 0 8px 12px rgba(0, 0, 0, 0.08);
            padding: 10px;
            min-width: 150px;
            max-height: 240px;
            overflow-y: auto;
        }
        .dropdown-filter.show .checkbox-dropdown-content {
            display: block;
        }
        .checkbox-dropdown-actions {
            display: flex;
            justify-content: start;
            margin-bottom: 8px;
        }
        .checkbox-dropdown-actions button {
            font-size: 10px;
            padding: 1px 4px;
            background-color: #f4f4f4;
            border: 1px solid #ccc;
            border-radius: 4px;
            cursor: pointer;
        }
        .checkbox-dropdown-actions button:hover {
            background-color: #e9e9e9;
        }
        .checkbox-options label {
            display: flex;
            align-items: center;
            margin-bottom: 6px;
            font-size: 10px;
            gap: 6px;
            cursor: pointer;
        }
        .checkbox-options input[type="checkbox"] {
            margin: 0;
            transform: scale(1.1);
        }
        .table-bordered th, .table-bordered td { border: 1px solid #dee2e6; }
        #orderTableBody { font-size: 14px !important; }

        /* Make dropdown filter text black */
        .checkbox-dropdown-content,
        .checkbox-dropdown-content label,
        .checkbox-dropdown-content input,
        .checkbox-dropdown-actions button {
            color: #000 !important;
        }
        .card-body {
            padding: 0rem !important;
        }
        .form-control {
            font-size: 0.8rem !important;
            padding: 0.25rem 0.25rem !important;
        }
        .form-select {
            font-size: 0.850rem !important;
            padding: 0.25rem 0.25rem !important;
        }

        .unit-dropdown .checkbox-options label,
        .unit-dropdown .checkbox-options input {
            cursor: default;
        }
    </style>

    <style>
        #DataTables_Table_0_filter {
            display: none !important;
        }
        #DataTables_Table_1_filter {
            display: none !important;
        }
        #DataTables_Table_0, .table th, .table td{
            padding:0.3rem !important;
            
        }
        #DataTables_Table_1, .table th, .table td {
            padding: 0.0rem 0.3rem !important;
        }
        .cap-month-cell {
            cursor: pointer;
        }

        .switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 25px;
        font-family: Arial, sans-serif;
        font-size: 12px;
        }

        .switch input {
        opacity: 0;
        width: 0;
        height: 0;
        }

        .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 25px;
        }

        .slider:before {
        position: absolute;
        content: "Str";
        height: 21px;
        width: 34px;
        left: 2px;
        bottom: 2px;
        background-color: white;
        color: #000;
        text-align: center;
        line-height: 21px;
        transition: .4s;
        border-radius: 20px;
        font-weight: bold;
        font-size: 12px;
        }

        input:checked + .slider {
        background-color: #2196F3;
        }

        input:focus + .slider {
        box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
        transform: translateX(22px); /* 60 - knob width (34) - padding (2) = 24px, small fine-tune for better visual */
        content: "Mac";
        }

    </style>

    <style>
        body {
        background-color: #f8f9fa;
        font-family: 'Segoe UI', sans-serif;
    }

    .table-container {
        border-radius: 12px;
        overflow-x: auto;
        background-color: #fff;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        margin-top: 20px;
        padding: 10px;
    }
    
    #capacityTable th {
        font-size: 1rem !important;
        background-color:rgb(237, 228, 253);
        color: #fff;
        vertical-align: middle;
    }

    #capacityTable td {
        font-size: 0.85rem !important;
        padding: 0.4rem 0.5rem !important;
        color: #212529;
        vertical-align: middle;
    }

    .bg-light {
        background-color: #f8f9fa !important;
    }

    .fw-bold {
        font-weight: 600;
    }

    .fw-semibold {
        font-weight: 500;
    }

    .text-dark {
        color: #212529 !important;
    }

    .cap-month-cell {
        transition: all 0.2s ease-in-out;
    }

    .cap-month-cell:hover,
    .cap-total-cell:hover {
        background-color: #eef3fd !important;
        box-shadow: 0 0 4px #c7d6f3 inset;
    }


    .cap-month-cell .bg-danger {
        background-color: #dc3545 !important;
        color: #fff;
    }

    .cap-month-cell .bg-warning {
        background-color: #ffc107 !important;
        color: #212529;
    }

    .cap-month-cell .bg-success {
        background-color: #198754 !important;
        color: #fff;
    }

    .cap-month-cell .bg-purple {
        background-color: #6f42c1 !important;
        color: #fff;
    }

    .cap-month-cell div {
        font-size: 0.75rem;
    }

    #capacityTable .table th, #capacityTable .table td {
        text-align: center;
        vertical-align: middle !important;
    }

    #capacityTable .table thead th {
        border-bottom: 2px solid #dee2e6;
    }

    #capacityTable .table-bordered {
        border: 1px solid #dee2e6;
    }

    #capacityTable .table-bordered td, #capacityTable .table-bordered th {
        border: 1px solid #dee2e6;
    }

    .sticky-header thead th {
        position: sticky;
        top: 0;
        background-color:rgb(4, 33, 122) !important;
        z-index: 10;
    }
    .badge-text {
        font-size: 0.75rem;
        font-weight: bold;
        padding: 2px 6px;
        border-radius: 8px;
        display: inline-block;
        color: white;
    }

    .red { background-color: #e53935; }
    .yellow { background-color: #fbc02d; color: black; }
    .green { background-color: #43a047; }
    .purple { background-color: #800080;  }

</style>

    <style>
        #orderTableContainer {
            max-height: 380px;
            min-height: 380px;
            overflow-y: auto;
            scrollbar-width: none; /* For Firefox */
            -ms-overflow-style: none; /* For Internet Explorer and Edge */
        }

        /* For Chrome, Safari, and Opera */
        #orderTableContainer::-webkit-scrollbar {
            display: none;
        }
        /* #orderTableBody {
            display: block;
            height: 400px;
            min-height: 400px;
            max-height: 400px;
            overflow-y: auto;
        }
        #orderTable thead, #orderTable tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
            -webkit-overflow-scrolling: none;
        } */

        table.dataTable {
            border-color: #dedede !important;
            border-collapse: collapse !important;
            border-spacing: 0 !important;
        }

        #selectedMonthText {
            font-weight: bold;
            color: #000 !important;
        }

        @media (max-width: 1899px) {
            #orderTable thead th {
                font-size: 10px !important;
            }
            #capoverall {
                font-size: 0.7rem !important;
            }
        }

        #orderTableHeader.sticky-active th {
            position: sticky;
            top: -1px;
            background-color: rgb(200, 205, 210) !important;
            z-index: 10;
            border: none !important;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Optional shadow for clarity */
        }

        .modal_popup {
            max-width: 1100px !important;
        }

        
    </style>
    <style>
        /* Hide number input arrows in all browsers */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }


        .toggle-history:hover {
            text-decoration: underline;
            color: #0d6efd; /* Optional: keep it primary blue */
            transition: all 0.8s ease-in-out;
        }

    </style>
    
</head>
<body>
     @php
        
        $empl_no = Session::get('empl_id');
        $empl_name = Session::get('emp_name');
    @endphp

    <div class="container-fluid pb-3 pt-0">
        <!-- Toast Notification -->
            <div class="toast-container position-fixed top-0 mx-auto p-3">
                <div id="clickToast" class="toast align-items-center text-white bg-dark border-0" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body"></div>
                    </div>
                </div>
            </div>
            <!-- Rest of your existing HTML remains unchanged -->
            <div class="d-flex justify-content-between align-items-center mb-3 mt-3">
                <div>
                    <a href="/dashboard" class="btn btn-link text-dark p-0 ms-1" title="Go to Dashboard">
                            <i class="fas fa-home fa-lg"></i>
                        </a>
                        <a href="/microplan" class="btn btn-link text-dark p-0 ms-3" target="_blank" title="Go to Dashboard">
                            <i class="fas fa-tasks fa-lg"></i>
                    </a>
                </div>
                <h5 class="fw-bold mb-0">Macro Planning Overview - Garments Division</h5>
                <div class="d-flex align-items-center">
                    <div id="capacitySpinner" class="spinner-border spinner-border-sm text-primary mx-auto" style="display: none; margin-right: 10px !important;" role="status"><span class="visually-hidden">Loading...</span></div>
                    <div class="d-flex align-items-center gap-2" id="type_switch">
                        <!-- Rounded switch -->
                        <label class="switch type_switch me-3">
                        <input type="checkbox" id="TypeToggle" >
                        <span class="slider round"></span>
                        </label>
                    </div>
                </div>
            </div>
            <!-- ... rest of your HTML ... -->


        <!-- Date Range Filter -->
    
 
    <!-- Table -->
    <div class="">

    @php
    use Carbon\Carbon;
    $months = collect(range(0, 10))->map(fn($i) => Carbon::now()->startOfMonth()->addMonths($i)->format('M-y'))->toArray();
@endphp

<div class="table-responsive">
    <table id="capacityTable" class="table table-sm table-bordered text-center align-middle sticky-header">
        <thead>
            <tr>
                <th>
                    <div>Factory</div>
                    <div><span class="text-danger" style="font-size: 0.7rem;">(Mins In Lakhs)</span></div>
                </th>
                @foreach($months as $m) <th>{{ $m }}</th> @endforeach
                <th>Total</th>
            </tr>
        </thead>
        <tbody id="capacityTableBody">
            {{-- Dynamically populated via JS --}}
        </tbody>
    </table>
</div>

    
    
    
    <!-- <div id="preloder">
        <div class="lds-hourglass">

        </div>
    </div>  -->
                        

    <div class="modal fade" id="exitDateModal" tabindex="-1" aria-labelledby="exitDateModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header text-dark">
                    <h5 class="modal-title" id="exitDateModalLabel">Select Ex_Fac_Date and Unit for <span id="modalOCN"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- History Toggle -->
                    <div class="text-end">
                    <p class="toggle-history fw-bold mb-3 text-primary me-0" style="cursor: pointer;">View history</p>
                    </div>
                    <!-- History Table -->       
                    <div class="mb-4 history-table-container" style="display: none;">
                        <h6 class="fw-bold mb-2">Selection History</h6>
                        <div class="table-responsive" style="max-height: 200px;">
                            <table class="table table-sm table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 10%;">Exit_Date</th>
                                        <th style="width: 10%;">Unit</th>
                                        <th style="width: 10%;">Comment</th>
                                        <th style="width: 55%;">QTY</th>
                                        <th style="width: 15%;">Booked by</th>
                                    </tr>
                                </thead>
                                <tbody id="exitDateHistoryBody"></tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Input Section -->
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label for="modalExitDate" class="form-label fw-semibold">Exit Date</label>
                            <input type="text" class="form-control" id="modalExitDate" placeholder="Select date">
                        </div>
                        <!-- Split Quantity Input -->
                        <div class="col-md-2">
                            <label for="splitQuantity" class="form-label small"><strong>Split Quantity</strong></label>
                            <div class="input-group input-group-sm">
                                <button class="btn btn-outline-secondary" type="button" id="decrementSplit">-</button>
                                <input type="number" class="form-control text-center" id="splitQuantity" min="1" max="5" value="1" style="-moz-appearance: textfield;">
                                <button class="btn btn-outline-secondary" type="button" id="incrementSplit">+</button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div id="unitSelectorsContainer">
                                <!-- Empty container - units will be added dynamically -->
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div id="bal_unitsContainer">
                                <!-- Empty container - units will be added dynamically -->
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="exitremarks" class="form-label fw-semibold">Remarks for Exit Date</label>
                            <textarea class="form-control" id="exitremarks" rows="3" placeholder="Enter remarks"></textarea>
                        </div>
                    </div>
                    <div class="col-md-2 d-flex align-items-center">
                        <label class="form-label fw-semibold me-2 mb-0">Total Units:</label>
                        <div id="totalUnits" class="fw-bold">0</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="saveExitDate">Update</button>
                </div>
            </div>
        </div>
    </div>






    <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1055;">
        <div id="efdToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <strong class="me-auto">Notification</strong>
                <small>Just now</small>
                <!-- <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button> -->
            </div>
            <div class="toast-body">
                <!-- Dynamic message will be inserted here -->
            </div>
        </div>
    </div>

    </div>
       
                <div class="d-flex justify-content-between align-items-center mb-3 mt-1">
                    <div class="d-flex align-items-center">
                        <h5 class="fw-bold mb-0 me-5">🧵 Order Planning Dashboard</h5>
                        <span id="selectedMonthText" class="text-primary small p-1" style="background-color:#F0F0F0; border-radius:5px;"></span>
                    </div>
                    <div class="d-flex align-items-center">
                        <div id="aggregatedSpinner" class="spinner-border spinner-border-sm text-primary" style="display: none; margin-right: 8px;" role="status"><span class="visually-hidden">Loading...</span></div>
                        <div class="form-check form-switch mb-0">
                            <input type="checkbox" id="aggregatedView" class="form-check-input">
                            <label class="form-check-label" for="aggregatedView">Aggregated View</label>
                        </div>
                    </div>
                </div>
                <div class="table-responsive" id="orderTableContainer">
                    <table class="table table-bordered table-hover align-middle" id="orderTable">
                        <thead class="table-secondary text-white text-center" id="orderTableHeader" style=" position: sticky; top: -1px; z-index: 1;">
                            <tr>
                                <th>
                                    <div class="dropdown-filter" data-column="0">    
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-filter me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    Buyer
                                </th>
                                <th>
                                    
                                    <div class="dropdown-filter" data-column="1">
                                    <button class="filter-toggle" title="Filter this column"><i class="fas fa-magnifying-glass me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    OCN
                                </th>
                                <th class="col-color">
                                    
                                    <div class="dropdown-filter" data-column="2">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-filter me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    Color
                                </th>
                                <th class="col-item">
                                    
                                    <div class="dropdown-filter" data-column="3">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-filter me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    Item
                                </th>
                                <th>Order Qty</th>
                                <th>SAM</th>
                                <th>Bal to sew</th>
                                <th>Value(INR)</th>
                                <th>Bal to sew Mins</th>
                                <th>
                                    
                                    <div class="dropdown-filter" data-column="8">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-calendar me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <input type="text" class="form-control date-range-filter" id="factoryExitDateRange" placeholder="Select range" autocomplete="off" style="margin-bottom:8px;" />
                                            <button class="clear-date-range btn btn-sm btn-light w-100">Clear</button>
                                        </div>
                                    </div>
                                    Ex Fac Date
                                </th>
                                <th> 
                                   
                                    <div class="dropdown-filter" data-column="9">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-calendar me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <input type="text" class="form-control date-range-filter" id="shippingDateRange" placeholder="Select range" autocomplete="off" style="margin-bottom:8px;" />
                                            <button class="clear-date-range btn btn-sm btn-light w-100">Clear</button>
                                        </div>
                                    </div>
                                    Ship Date
                                </th>
                                <th class="text-center">Prod mon</th>
                                <th class="text-center">FI_Date</th>
                                <th>
                                    
                                    <div class="dropdown-filter" data-column="13">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-filter me-1"></i></button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    Unit
                                </th>
                                <th>
                                    
                                    <div class="dropdown-filter" data-column="14">
                                        <button class="filter-toggle" title="Filter this column"><i class="fas fa-filter me-1"></i></button>
                                        <div class="checkbox-dropdown-content " style="width: 120px !important">
                                            <div class="checkbox-dropdown-actions gap-2">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                    Status
                                </th>
                            </tr>
                        </thead>
                        <tbody id="orderTableBody"></tbody>
                        <tfoot class="table-secondary" style="position: sticky; bottom: -2px;">
                            <tr>
                                <td class="text-end fw-bold">Total<span class="text-danger"> (in Lakhs)</span></td> <!-- Buyer -->
                                <td></td> <!-- OCN -->
                                <td class="col-color-footer"></td> <!-- Color -->
                                <td class="col-item-footer"></td> <!-- Item -->
                                <td></td>
                                <td></td> <!-- SAM -->
                                <td class="text-end fw-bold"></td> <!-- Bal. to Sew -->
                                <td class="text-end fw-bold"></td> <!-- Value -->
                                <td class="text-end fw-bold"></td> <!-- Booked Min. -->
                                <td></td> <!-- FED -->
                                <td></td> <!-- Shipping Date -->
                                <td></td> <!-- Prod mon -->
                                <td></td> 
                                <td></td> <!-- Unit -->
                                <td></td> <!-- Status -->
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <!--Production popup-->
                <div class="modal fade" id="tableModalproduction" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal_popup">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="tableModalLabelproduction"></h5>
                                <span id="noteText" class="ms-3"></span>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>


                            <div class="modal-body">
                                <h6>PRODUCTION ABSTRACT:</h6>
                                <table class="table table-bordered table_popup table_production" id="abstractTable">
                                    <thead class="header-fixed">
                                        <tr>
                                            <th rowspan="2">S.No</th>
                                            <th rowspan="2">ITEM</th>
                                            <th rowspan="2">COLOR</th>
                                            <th rowspan="2">ORDER</th>
                                            <th rowspan="2">BOM</th>
                                            <th colspan="2" class="centerallign">CUTTING</th>
                                            <th colspan="2" class="centerallign">LINE INPUT</th>
                                            <th colspan="4" class="centerallign">LINE OUTPUT</th>
                                            <th colspan="6" class="centerallign">FINISHING</th>

                                        </tr>
                                        <tr>
                                            <!--  CUTTING -->
                                            <th>QTY</th>
                                            <th>PENDING</th>
                                            <!-- LINE INPUT -->
                                            <th>QTY</th>
                                            <th>PENDING</th>
                                            <!-- LINE OUTPUT -->
                                            <th>QTY</th>
                                            <!-- <th>PENDING</th> -->
                                            <th>REJ</th>
                                            <th>WIP</th>
                                            <th>REJ%</th>
                                            <!-- FINISHING -->
                                            <th>PCKED</th>
                                            <th>PCK PEND</th>
                                            <th>SHIPPED</th>
                                            <th>SHIP PEND</th>
                                            <th>TFR IN</th>
                                            <th>TFR OUT</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" class="sideallign">Total:</th>
                                            <th id="abtotalQty" class="sideallign"></th>
                                            <th id="abtotalBomQty" class="sideallign"></th>
                                            <th id="abtotalCutQty" class="sideallign"></th>
                                            <th id="abtotalToBeCut" class="sideallign"></th>
                                            <th id="abtotalLineInput" class="sideallign"></th>
                                            <th id="abtotalCutVsInp" class="sideallign"></th>
                                            <th id="abtotalSewQty" class="sideallign"></th>
                                            <th id="abtotalRejQty" class="sideallign"></th>
                                            <th id="abtotalInpVsOutp" class="sideallign"></th>
                                            <th colspan="1" class="sideallign"></th>
                                            <th id="abtotalPckedQty" class="sideallign"></th>
                                            <th id="abtotalAckVsPck" class="sideallign"></th>
                                            <th id="abtotalShippedQty" class="sideallign"></th>
                                            <th id="abtotalPckVsShip" class="sideallign"></th>
                                            <th id="abtotalStockIn" class="sideallign"></th>
                                            <th id="abtotalStockOut" class="sideallign"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                
                                <div class="mt-3">
                                    <h6 id="productionfilter_title"></h6>
                                </div>
                                <table class="table table-bordered table_popup mb-3" id="productionfilter">
                                    <thead></thead>
                                    <tbody></tbody>
                                </table>

                                <div class="mt-3">
                                    <h6>PRODUCTION DETAILS:</h6>
                                </div>

                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <select id="itemDropdown" class="form-select">
                                            <option value="">Select Item</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <select id="colorDropdown" class="form-select">
                                            <option value="">Select Color</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <select id="sizeDropdown_over" class="form-select">
                                            <option value="">Select Size</option>
                                        </select>
                                    </div>
                                    
                                </div>
                                <table class="table table-bordered table_popup table_production" id="detailsTable">
                                    <thead class="header-fixed">
                                        <tr>
                                            <th rowspan="2">S.No</th>
                                            <th rowspan="2">ITEM</th>
                                            <th rowspan="2">COLOR</th>
                                            <th rowspan="2">SIZE</th>
                                            <th rowspan="2">ORDER</th>
                                            <th rowspan="2">BOM</th>
                                            <th colspan="2" class="centerallign">CUTTING</th>
                                            <th colspan="2" class="centerallign">LINE INPUT</th>
                                            <th colspan="4" class="centerallign">LINE OUTPUT</th>
                                            <th colspan="6" class="centerallign">FINISHING</th>

                                        </tr>
                                        <tr>
                                            <!--  CUTTING -->
                                            <th>QTY</th>
                                            <th>PENDING</th>
                                            <!-- LINE INPUT -->
                                            <th>QTY</th>
                                            <th>PENDING</th>
                                            <!-- LINE OUTPUT -->
                                            <th>QTY</th>
                                            <!-- <th>PENDING</th> -->
                                            <th>REJ</th>
                                            <th>WIP</th>
                                            <th>REJ%</th>
                                            <!-- FINISHING -->
                                            <th>PCKED</th>
                                            <th>PCK PEND</th>
                                            <th>SHIPPED</th>
                                            <th>SHIP PEND</th>
                                            <th>TFR IN</th>
                                            <th>TFR OUT</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="4" class="sideallign">Total:</th>
                                            <th id="totalOrQty" class="sideallign"></th>
                                            <th id="totalBomQty" class="sideallign"></th>
                                            <th id="totalCutQty" class="sideallign"></th>
                                            <th id="totalToBeCut" class="sideallign"></th>
                                            <th id="totalLineInput" class="sideallign"></th>
                                            <th id="totalCutVsInp" class="sideallign"></th>
                                            <th id="totalSewQty" class="sideallign"></th>
                                            <th id="totalRejQty" class="sideallign"></th>
                                            <th id="totalInpVsOutp" class="sideallign"></th>
                                            <th colspan="1" class="sideallign"></th>
                                            <th id="totalPckedQty" class="sideallign"></th>
                                            <th id="totalAckVsPck" class="sideallign"></th>
                                            <th id="totalShippedQty" class="sideallign"></th>
                                            <th id="totalPckVsShip" class="sideallign"></th>
                                            <th id="totalStockIn" class="sideallign"></th>
                                            <th id="totalStockOut" class="sideallign"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <!-- <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div> -->
                        </div>
                    </div>
                </div>
    </div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">



<script>
     $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });

    

    let productionTable = null;
    let abstractTable = null;

    $(document).on('click', '.production', function() {
        $("#preloder").fadeIn();
        let orderNo = $(this).data('order-no');
        $('#tableModalLabelproduction').text('PRODUCTION STATUS - ' + orderNo);
        $('#noteText').text('Note: All columns represent quantities.');
        orderNo = orderNo.replace(/\\/g, '-');

        const sizeurl = `{{ route('sizebreakup') }}`;
        const abstracturl = `{{ route('productstatus') }}`;

        // console.log('sizeurl', sizeurl);
        //console.log('abstracturl', abstracturl);

        // Fetch Size Breakup Data
        $.ajax({
            url: sizeurl,
            method: 'GET',
            data: {
                orderNo: orderNo
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function(response) {
                $("#preloder").fadeOut();
                //console.log('Size Breakup Response:', response);
                if (response.success) {
                    populateDetailsTable(response.data, orderNo);
                } else {
                    console.error('Error fetching details data:', response.message);
                }
            },
            error: function(xhr, status, error) {
                $("#preloder").fadeOut();
                console.error('Error fetching details data:', error);
            }
        });

        // Fetch Production Abstract Data
        $.ajax({
            url: abstracturl,
            method: 'GET',
            data: {
                orderNo: orderNo
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function(response) {
                // $("#preloder").fadeOut();
                // console.log('Production Abstract Response:', response);
                if (response.success) {
                    populateAbstractTable(response.data, orderNo);
                } else {
                    console.error('Error fetching abstract data:', response.message);
                }
            },
            error: function(xhr, status, error) {
                $("#preloder").fadeOut();
                console.error('Error fetching abstract data:', error);
            }
        });
    });

    function populateDetailsTable(data, orderNo) {
        const $tableBody = $('#detailsTable tbody');
        const $colorDropdown = $('#colorDropdown');
        const $itemDropdown = $('#itemDropdown');
        const $sizeDropdown = $('#sizeDropdown_over');
        $tableBody.empty();
        let Colors = [];
        let Item = [];
        let Size = [];

        $.each(data, function(index, item) {
            Colors.push(item.Color);
            Item.push(item.Item);
            Size.push(item.Size);
            const row = `
                <tr>
                    <td>${index + 1}</td>
                    <td>${item.Item}</td>
                    <td>${item.Color}</td>
                    <td>${item.Size}</td>
                    <td class="sideallign">${parseInt(item.Order_Qty) || 0}</td>
                    <td class="sideallign">${parseInt(item.Bom_Qty) || 0}</td>
                    <td class="sideallign">${parseInt(item.Cut_Qty) || 0}</td>
                    <td class="sideallign">${item.To_be_Cut == 0 ? '-' : item.To_be_Cut}</td>
                    <td class="sideallign">${item.Line_Input}</td>
                    <td class="sideallign">${item.Cut_Vs_Inp == 0 ? '-' : item.Cut_Vs_Inp}</td>
                    <td class="sideallign">${parseInt(item.Sew_Qty) || 0}</td>
                    <td class="sideallign">${parseInt(item.Rej_Qty) == 0 ? '-' : parseInt(item.Rej_Qty) || 0}</td>
                    <td class="sideallign">${item.Inp_Vs_Outp == 0 ? '-' : item.Inp_Vs_Outp}</td>
                    <td>${item.Rej_Per}</td>
                    <td class="sideallign">${parseInt(item.Pcked_Qty) || 0}</td>
                    <td class="sideallign">${item.Ack_vs_Pck}</td>
                    <td class="sideallign">${parseInt(item.Shipped_Qty) || 0}</td>
                    <td class="sideallign">${item.Pck_Vs_Ship == 0 ? '-' : item.Pck_Vs_Ship}</td>
                    <td class="sideallign">${item.Stock_In == 0 ? '-' : item.Stock_In}</td>
                    <td class="sideallign">${item.Stock_Out == 0 ? '-' : item.Stock_Out}</td>
                </tr>
            `;
            $tableBody.append(row);
        });

        Colors = [...new Set(Colors)];
        $colorDropdown.empty();
        $colorDropdown.append('<option value="">All Color</option>');
        Colors.forEach(function(color) {
            $colorDropdown.append(`<option value="${color}">${color}</option>`);
        });

        Item = [...new Set(Item)];
        $itemDropdown.empty();
        $itemDropdown.append('<option value="">All Item</option>');
        Item.forEach(function(item) {
            $itemDropdown.append(`<option value="${item}">${item}</option>`);
        });

        Size = [...new Set(Size)];
        $sizeDropdown.empty();
        $sizeDropdown.append('<option value="">All Size</option>');
        Size.forEach(function(size) {
            $sizeDropdown.append(`<option value="${size}">${size}</option>`);
        });

        // Initialize DataTable for Details
        if (!productionTable) {
            productionTable = $('#detailsTable').DataTable({
                paging: false,
                searching: true,
                ordering: true,
                responsive: true,
                order: [
                    [0, 'asc']
                ],
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excelHtml5',
                        title: 'PRODUCTION DETAILS - ' + orderNo,
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: true
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'PRODUCTION DETAILS - ' + orderNo,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: true
                    }
                ],
                footerCallback: function(row, data, start, end, display) {
                    calculateDetailsTotals(this.api().rows({
                        search: 'applied'
                    }).data().toArray());
                }
            });
        } else {
            productionTable.buttons().container().appendTo('#detailsTable .col-md-6:eq(0)');
        }

        $colorDropdown.off('change').on('change', function() {
            const selectedColor = $(this).val();
            if (selectedColor === "") {
                productionTable.columns(2).search('').draw();
            } else {
                productionTable.columns(2).search('^' + selectedColor + '$', true, false).draw();
            }

            const filteredData = productionTable.rows({
                search: 'applied'
            }).data().toArray();
            calculateDetailsTotals(filteredData);
        });

        $sizeDropdown.off('change').on('change', function() {
            const selectedSize = $(this).val();
            if (selectedSize === "") {
                productionTable.columns(3).search('').draw();
            } else {
                productionTable.columns(3).search('^' + selectedSize + '$', true, false).draw();
            }

            const filteredsizeData = productionTable.rows({
                search: 'applied'
            }).data().toArray();
            calculateDetailsTotals(filteredsizeData);
        });
        $itemDropdown.off('change').on('change', function() {
            const selectedItem = $(this).val();
            if (selectedItem === "") {
                productionTable.columns(1).search('').draw();
            } else {
                productionTable.columns(1).search('^' + selectedItem + '$', true, false).draw();
            }

            const filtereditemData = productionTable.rows({
                search: 'applied'
            }).data().toArray();
            calculateDetailsTotals(filtereditemData);
        });
    }

    $(document).ready(function() {
        let ProdFilterTable = null;
    });
    function productionfilterclick(funid,val) {
        let orderNo1 = $(val).data("orderid");
        let itemid = $(val).data("itemid");
        let colorid = $(val).data("colorid");
        orderNo1 = orderNo1.replace(/\\/g, '-');            
        $.ajax({
            url: `{{ route('productionfilter') }}`,
            method: 'GET',
            data: { orderNo: orderNo1, itemid: itemid, colorid: colorid, filter_type:funid },
            contentType: 'application/json',
            success: function (response) {
                if (response.data) {
                    response.data.forEach(item => {
                        delete item.Slno;
                    });
                }
                $("#preloder").fadeOut();
                // Production Filter Table 
                let columns1 = [];
                $('#productionfilter_title').html('Production Status - '+funid);
                ProductionFilterTable('#productionfilter', response.data, columns1, 2, 'productionfilter');
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                $("#preloder").fadeOut();
            }
        });
    }

    function ProductionFilterTable(tableId, data, columns, footerIndex, filterClassPrefix) {
        const tableElement = $(tableId);

            if ($.fn.DataTable.isDataTable('#productionfilter')) {
                let table = $('#productionfilter').DataTable();
                table.clear().destroy(); // Kill the DataTable
            }
            // Remove ANY DataTables-generated wrappers around the table
            $('#productionfilter').unwrap('.dataTables_wrapper');
            $('#productionfilter_filter').remove();
            $('#productionfilter_length').remove();
            $('#productionfilter_paginate').remove();
            $('#productionfilter_info').remove();
        // Add the correct structure: <thead>, <tbody>, <tfoot>
        const theadHtml = "<thead><tr>" + Object.keys(data[0]).map(key => `<th>${key}</th>`).join('') + "</tr></thead>";
        //const tfootHtml = "<tfoot><tr>" + Object.keys(data[0]).map(() => "<th></th>").join('') + "</tr></tfoot>";
        tableElement.html(`${theadHtml}<tbody></tbody>`); // Rebuild the table structure

        // Map columns with sanitized keys
        let sanitizedColumnMap = {};
        let sanitizedData = data.map(row => {
            let sanitizedRow = {};
            
            Object.keys(row).forEach(key => {
                let sanitizedKey = key.replace(/\s/g, '').replace(/\./g, '').replace(/[^a-zA-Z0-9_]/g, '');
                sanitizedColumnMap[sanitizedKey] = key;
                sanitizedRow[sanitizedKey] = row[key];
            });
            return sanitizedRow;
        });
        

        // Define DataTable columns
        columns.length = 0; // Clear any existing columns
        Object.keys(sanitizedColumnMap).forEach(sanitizedKey => {
            columns.push({ data: sanitizedKey });
        });

        // Initialize DataTable
        const ProdFilterTable = tableElement.DataTable({
            data: sanitizedData,
            columns: columns,
            ordering: false,
            paging: false,
            rowCallback: function(row, data, index) {
                let lastColumn = $('td:last-child', row); // Select the last column of the row
                lastColumn.css('font-weight', 'bold');
                // Check if it's the last row
                if (index === tableElement.DataTable().data().length - 1) {
                    $(row).css('font-weight', 'bold');
                    $('td', row).each(function() {
                        if ($(this).text().trim() === '1900-01-01') {
                            $(this).text('Total');
                        }
                    });
                }
            },
            footerCallback: function (row, data, start, end, display) {
                
            }
        });

        
    }

    function populateAbstractTable(data, orderNo) {
        const $tableBody = $('#abstractTable tbody');
        //$tableBody.empty();
        $('#productionfilter tbody').empty();
        $.each(data, function(index, item) {
            const row = `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${item.Item}</td>
                            <td>${item.Color}</td>
                            <td class="sideallign">${parseInt(item.Order_Qty) || 0}</td>
                            <td class="sideallign">${parseInt(item.Bom_Qty) || 0}</td>
                            <td class="sideallign" style="text-decoration: underline; color:blue; cursor: pointer;" data-orderid="${item.Order_No}" data-itemid="${item.Itemid}" data-colorid="${item.Colorid}" onclick="productionfilterclick('Cut',this);">${parseInt(item.Cut_Qty) || 0}</td>
                            <td class="sideallign">${item.To_be_Cut == 0 ? '-' : item.To_be_Cut}</td>
                            <td class="sideallign" style="text-decoration: underline; color:blue; cursor: pointer;" data-orderid="${item.Order_No}" data-itemid="${item.Itemid}" data-colorid="${item.Colorid}" onclick="productionfilterclick('Input',this);">${item.Line_Input}</td>
                            <td class="sideallign">${item.Cut_Vs_Inp == 0 ? '-' : item.Cut_Vs_Inp}</td>
                            <td class="sideallign" style="text-decoration: underline; color:blue; cursor: pointer;" data-orderid="${item.Order_No}" data-itemid="${item.Itemid}" data-colorid="${item.Colorid}" onclick="productionfilterclick('Audit',this);">${parseInt(item.Sew_Qty) || 0}</td>
                            <td class="sideallign">${parseInt(item.Rej_Qty) == 0 ? '-' : parseInt(item.Rej_Qty) || 0}</td>
                            <td class="sideallign">${item.Inp_Vs_Outp == 0 ? '-' : item.Inp_Vs_Outp}</td>
                            <td>${item.Rej_Per}</td>
                            <td class="sideallign" style="text-decoration: underline; color:blue; cursor: pointer;" data-orderid="${item.Order_No}" data-itemid="${item.Itemid}" data-colorid="${item.Colorid}" onclick="productionfilterclick('Fgs',this);">${parseInt(item.Pcked_Qty) || 0}</td>
                            <td class="sideallign">${item.Ack_vs_Pck}</td>
                            <td class="sideallign">${parseInt(item.Shipped_Qty) || 0}</td>
                            <td class="sideallign">${item.Pck_Vs_Ship == 0 ? '-' : item.Pck_Vs_Ship}</td>
                            <td class="sideallign">${item.Stock_In == 0 ? '-' : item.Stock_In}</td>
                            <td class="sideallign">${item.Stock_Out == 0 ? '-' : item.Stock_Out}</td>
                        </tr>
                    `;
            $tableBody.append(row);
        });

        // Initialize DataTable for Abstract
        if (!abstractTable) {
            abstractTable = $('#abstractTable').DataTable({
                paging: false,
                searching: true,
                ordering: true,
                responsive: true,
                order: [
                    [0, 'asc']
                ],
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excelHtml5',
                        title: 'PRODUCTION ABSTRACT - ' + orderNo,
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: true
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'PRODUCTION ABSTRACT - ' + orderNo,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: true
                    }
                ],
                footerCallback: function(row, data, start, end, display) {
                    calculateAbstractTotals(this.api().rows({
                        search: 'applied'
                    }).data().toArray());
                }
            });
        } else {
            abstractTable.buttons().container().appendTo('#abstractTable .col-md-6:eq(0)');
        }
    }

    function calculateDetailsTotals(data) {
        let totalOrQty = 0;
        let totalBomQty = 0;
        let totalCutQty = 0;
        let totalToBeCut = 0;
        let totalLineInput = 0;
        let totalCutVsInp = 0;
        let totalSewQty = 0;
        let totalRejQty = 0;
        let totalInpVsOutp = 0;
        let totalPckedQty = 0;
        let totalAckVsPck = 0;
        let totalShippedQty = 0;
        let totalPckVsShip = 0;
        let totalStockIn = 0;
        let totalStockOut = 0;

        // console.log('Data received for details totals:', data);

        data.forEach(function(rowData) {
            totalOrQty += parseInt(rowData[4]) || 0;
            totalBomQty += parseInt(rowData[5]) || 0;
            totalCutQty += parseInt(rowData[6]) || 0;
            totalToBeCut += parseInt(rowData[7]) || 0;
            totalLineInput += parseInt(rowData[8]) || 0;
            totalCutVsInp += parseInt(rowData[9]) || 0;
            totalSewQty += parseInt(rowData[10]) || 0;
            totalRejQty += parseInt(rowData[11]) || 0;
            totalInpVsOutp += parseInt(rowData[12]) || 0;
            totalPckedQty += parseInt(rowData[14]) || 0;
            totalAckVsPck += parseInt(rowData[15]) || 0;
            totalShippedQty += parseInt(rowData[16]) || 0;
            totalPckVsShip += parseInt(rowData[17]) || 0;
            totalStockIn += parseInt(rowData[18]) || 0;
            totalStockOut += parseInt(rowData[19]) || 0;
        });

        $('#totalOrQty').text(totalOrQty);
        $('#totalBomQty').text(totalBomQty);
        $('#totalCutQty').text(totalCutQty);
        $('#totalToBeCut').text(totalToBeCut);
        $('#totalLineInput').text(totalLineInput);
        $('#totalCutVsInp').text(totalCutVsInp);
        $('#totalSewQty').text(totalSewQty);
        $('#totalRejQty').text(totalRejQty);
        $('#totalInpVsOutp').text(totalInpVsOutp);
        $('#totalPckedQty').text(totalPckedQty);
        $('#totalAckVsPck').text(totalAckVsPck);
        $('#totalShippedQty').text(totalShippedQty);
        $('#totalPckVsShip').text(totalPckVsShip);
        $('#totalStockIn').text(totalStockIn);
        $('#totalStockOut').text(totalStockOut);




    }

    function calculateAbstractTotals(data) {
        let abtotalQty = 0;
        let abtotalBomQty = 0;
        let abtotalCutQty = 0;
        let abtotalToBeCut = 0;
        let abtotalLineInput = 0;
        let abtotalCutVsInp = 0;
        let abtotalSewQty = 0;
        let abtotalRejQty = 0;
        let abtotalInpVsOutp = 0;
        let abtotalPckedQty = 0;
        let abtotalAckVsPck = 0;
        let abtotalShippedQty = 0;
        let abtotalPckVsShip = 0;
        let abtotalStockIn = 0;
        let abtotalStockOut = 0;

        //console.log('Data received for abstract totals:', data);


        data.forEach(function(rowData) {
            abtotalQty += parseInt(rowData[3]) || 0;
            abtotalBomQty += parseInt(rowData[4]) || 0;
            abtotalCutQty += parseInt(rowData[5]) || 0;
            abtotalToBeCut += parseInt(rowData[6]) || 0;
            abtotalLineInput += parseInt(rowData[7]) || 0;
            abtotalCutVsInp += parseInt(rowData[8]) || 0;
            abtotalSewQty += parseInt(rowData[9]) || 0;
            abtotalRejQty += parseInt(rowData[10]) || 0;
            abtotalInpVsOutp += parseInt(rowData[11]) || 0;
            abtotalPckedQty += parseInt(rowData[13]) || 0;
            abtotalAckVsPck += parseInt(rowData[14]) || 0;
            abtotalShippedQty += parseInt(rowData[15]) || 0;
            abtotalPckVsShip += parseInt(rowData[16]) || 0;
            abtotalStockIn += parseInt(rowData[17]) || 0;
            abtotalStockOut += parseInt(rowData[18]) || 0;
        });

        $('#abtotalQty').text(abtotalQty);
        $('#abtotalBomQty').text(abtotalBomQty);
        $('#abtotalCutQty').text(abtotalCutQty);
        $('#abtotalToBeCut').text(abtotalToBeCut);
        $('#abtotalLineInput').text(abtotalLineInput);
        $('#abtotalCutVsInp').text(abtotalCutVsInp);
        $('#abtotalSewQty').text(abtotalSewQty);
        $('#abtotalRejQty').text(abtotalRejQty);
        $('#abtotalInpVsOutp').text(abtotalInpVsOutp);
        $('#abtotalPckedQty').text(abtotalPckedQty);
        $('#abtotalAckVsPck').text(abtotalAckVsPck);
        $('#abtotalShippedQty').text(abtotalShippedQty);
        $('#abtotalPckVsShip').text(abtotalPckVsShip);
        $('#abtotalStockIn').text(abtotalStockIn);
        $('#abtotalStockOut').text(abtotalStockOut);

    }

    $('#tableModalproduction').on('hidden.bs.modal', function() {
        if (productionTable) {
            productionTable.destroy();
            productionTable = null;
        }
        if (abstractTable) {
            abstractTable.destroy();
            abstractTable = null;
        }
        $('#detailsTable tbody').empty();
        $('#abstractTable tbody').empty();
    });
</script>

<script>
       
            $('#orderTableContainer').on('scroll', function () {
                const thead = $('#orderTable thead');
                if ($(this).scrollTop() > 0) {
                    thead.addClass('sticky-active');
                } else {
                    thead.removeClass('sticky-active');
                }
            });

            let unitOptions = [];
            let table = null;
            let originalPlanData = [];
            var unitcode = [];

            function formatDate(dateStr) {
                if (!dateStr) return "";
                const d = new Date(dateStr);
                return d.toLocaleDateString("en-GB").replace(/\/\d{4}$/, match => "/" + String(d.getFullYear()).slice(-2));
            }

            function formatSortableDate(dateStr) {
                if (!dateStr) return '';
                const parts = dateStr.split('/');
                if (parts.length !== 3) return '';
                let [d, m, y] = parts;
                d = d.padStart(2, '0');
                m = m.padStart(2, '0');
                y = y.length === 2 ? '20' + y : y;
                return `${y}-${m}-${d}`;
            }

            function formatToDDMMYY(dateStr) {
                if (!dateStr) return "";
                const date = moment(dateStr, ['YYYY-MM-DD', 'DD/MM/YYYY', 'DD-MM-YYYY', 'DD/MM/YY'], true);
                if (!date.isValid()) return "";
                return date.format('DD/MM/YY');
            }

            function formatToLakhs(value) {
                if (!value) return '0.00 L';
                return (value / 100000).toFixed(2);
            }

            function formatIndianNumber(num) {
                if (num === null || num === undefined || isNaN(num) || num === '') return '0';
                const value = Number(num);
                if (isNaN(value)) return '0';
                const [integerPart, decimalPart] = value.toString().split('.');
                let str = integerPart;
                let lastThree = str.slice(-3);
                let rest = str.slice(0, -3);
                if (rest !== '') {
                    lastThree = ',' + lastThree;
                }
                const formattedRest = rest.replace(/\B(?=(\d{2})+(?!\d))/g, ',');
                const formattedInteger = formattedRest + lastThree;
                return decimalPart ? `${formattedInteger}.${decimalPart}` : formattedInteger;
            }

            function formatProdMon(shipMonth) {
                if (!shipMonth || typeof shipMonth !== 'string' || shipMonth.trim() === '') return '';
                // Parse input in 'MMMM-YYYY' format (e.g., 'December-2025')
                const parsed = moment(shipMonth.trim(), 'MMMM-YYYY', true);
                if (!parsed.isValid()) {
                    console.warn(`Invalid Ship_Month format: ${shipMonth}`);
                    return '';
                }
                return parsed.format('MMM-YYYY'); // Output as 'MMM-YYYY' (e.g., 'Dec-2025')
            }

            function buildRow(row, units) {
                const shipDate = formatDate(row.Ship_Date);
                const shipDateSortable = row.Ship_Date ? new Date(row.Ship_Date).toISOString().slice(0, 10) : '';
                const exitDateSortable = row.exit_date ? new Date(row.exit_date).toISOString().slice(0, 10) : '';
                const prodMon = formatProdMon(row.Ship_Month);
                const fidate = formatDate(row.FI_Date);
                const fiDateSortable = row.FI_Date ? new Date(row.FI_Date).toISOString().slice(0, 10) : '';

                // Exit Date Style Logic (Red if past date)
                const formattedExitDate = row.exit_date ? formatToDDMMYY(row.exit_date) : '--';
                let exitDateStyle = '';
                if (row.exit_date) {
                    const today = moment().startOf('day');
                    const exitDateMoment = moment(row.exit_date, "YYYY-MM-DD").startOf('day');
                    if (exitDateMoment.isBefore(today)) {
                        exitDateStyle = 'color:red;';
                    }
                    else {
                          exitDateStyle = 'color:blue;';
                    }
                }

                let selectedUnit = row.Unit || "";
                if (!selectedUnit || selectedUnit === "null" || selectedUnit === "NULL" || selectedUnit.trim() === "") {
                    selectedUnit = "";
                }

                console.log("unitss", row);

                let allowedEmps = ['51052', '51099', '51123', '8686', '47781', '64441'];
                let currentEmp = "{{ trim(Session::get('empl_id')) }}";
                let isDisabled = !allowedEmps.includes(currentEmp);
                let selectedoption = isDisabled ? "disabled" : "";

                const unitSelect = `
                    <select class="form-select unit-select text-center" ${selectedoption}
                        data-itemid="${row?.Itemid || ''}" data-colorid="${row?.Colorid || ''}"
                        data-previous-value="${selectedUnit}">
                        <option value="" ${!selectedUnit ? "selected" : ""}>Unit</option>
                        ${units.map(unit => `
                            <option value="${unit}" ${selectedUnit === unit ? "selected" : ""}>${unit}</option>
                        `).join("")}
                    </select>
                `;

                let statusText = row.status || "--";
                let statusColor = "";

                let factoryexitdate = formatToDDMMYY(row.exit_date);
                let shipexitdate = moment(row.Ship_Date, "YYYY-MM-DD HH:mm:ss.SSS");
                let exitDate = moment(row.exit_date, "YYYY-MM-DD");
                let diffDays = exitDate.diff(shipexitdate, 'days');

                if (statusText === "On Time") statusColor = "green";
                else if (statusText === "Preponed") statusColor = "blue";
                else if (statusText === "Postponed") statusColor = "red";

                return `
                    <tr>
                        <td>${row.Buyer || ""}</td>
                        <td style="cursor: pointer; color: blue" data-bs-toggle="modal" data-bs-target="#tableModalproduction" class="production" data-title="production" 
                            data-order-no="${row.OCN}">${row.OCN || ""}</td>
                        <td class="col-color">${row.Color || ""}</td>
                        <td class="col-item">${row.Item || ""}</td>
                        <td class="text-end">${formatIndianNumber(row.Order_Qty) || ""}</td>
                        <td class="text-end">${formatIndianNumber(row.SAM) || ""}</td>
                        <td class="text-end">${formatIndianNumber(row.Bal_To_Sew) || ""}</td>
                        <td class="text-end">${formatIndianNumber(row.Value) || ""}</td>
                        <td class="text-end">${formatIndianNumber(row.Booked_Mins) || ""}</td>
                        <td class="text-center">
                            <span style="display:none">${exitDateSortable}</span>
                            <span class="factory-exit-date " 
                                style="cursor: ${isDisabled ? 'not-allowed' : 'pointer'}; ${exitDateStyle}"
                                data-itemid="${row.Itemid || ''}"
                                data-colorid="${row.Colorid || ''}"
                                data-empid="${window.emp_id || ''}"
                                data-shipdate="${shipDate}"
                                data-ocn="${row.OCN || ''}"
                                data-prev-exit="${row.pre_exit || ''}"
                                data-remarks="${row.remarks || ''}"
                                ${isDisabled ? '' : 'data-bs-toggle="modal" data-bs-target="#exitDateModal"'}
                            >
                                ${formattedExitDate}
                            </span>
                        </td>
                        <td class="text-center">
                            <span style="display:none">${shipDateSortable}</span>
                            ${shipDate}
                        </td>
                        <td class="text-center">${prodMon}</td>
                        <td class="text-center">
                            <span style="display:none">${fiDateSortable}</span>
                            ${fidate}
                        </td>
                        <td class="text-center">${unitSelect}</td>
                        <td class="text-center" style="color:${statusColor}">
                            ${(statusText.trim().toLowerCase() === "null") ? "--" : statusText}
                        </td>
                    </tr>`;
            }

            function renderTable(data, isAggregated, units) {
                if ($.fn.DataTable.isDataTable('#orderTable')) {
                    $('#orderTable').DataTable().destroy();
                }

                $('#orderTable').toggleClass('aggregated-view', isAggregated);

                if (!Array.isArray(data) || !Array.isArray(units)) {
                    console.error("renderTable() called with invalid data or units:", data, units);
                    return;
                }

                const tbody = document.getElementById("orderTableBody");
                const tfoot = document.querySelector("#orderTable tfoot");
                const fragment = document.createDocumentFragment();

                if (isAggregated) {
                    console.time("groupData");
                    data.forEach(row => {
                        const match = row.OCN?.match(/\d+$/);
                        row.OCNKey = match ? match[0] : (row.OCN || "Unknown");
                    });

                    const groupedData = data.reduce((acc, row) => {
                        const ocn = row.OCNKey;
                        if (!acc[ocn]) {
                            acc[ocn] = {
                                ...row,
                                OCN: ocn,
                                Bal_To_Sew: 0,
                                Booked_Mins: 0,
                                Value: 0,
                                SAM: 0,
                                count: 0,
                                unit: []
                            };
                        }
                        acc[ocn].Bal_To_Sew += parseFloat(row.Bal_To_Sew || 0);
                        acc[ocn].Booked_Mins += parseFloat(row.Booked_Mins || 0);
                        acc[ocn].Value += parseFloat(row.Value || 0);
                        acc[ocn].SAM += parseFloat(row.SAM || 0);
                        acc[ocn].count += 1;

                        let selectedUnit = (row.Unit || "").trim();
                        if (selectedUnit === "null" || selectedUnit === "NULL") selectedUnit = "";
                        const selectedUnitsArray = selectedUnit ? selectedUnit.split(',').map(u => u.trim()) : [];
                        selectedUnitsArray.forEach(unit => {
                            if (unit && !acc[ocn].unit.includes(unit)) {
                                acc[ocn].unit.push(unit);
                            }
                        });

                        return acc;
                    }, {});

                    Object.values(groupedData).forEach(group => {
                        group.unit = group.unit.length > 0 ? group.unit.join(", ") : "";
                    });

                    const groupedResult = Object.values(groupedData);
                    //console.timeEnd("groupData");

                    //console.log("Grouped Result:", groupedResult);

                    //console.time("generateRows");
                    groupedResult.forEach((row, index) => {
                        const shipDate = formatDate(row.Ship_Date);
                        const shipDateSortable = row.Ship_Date ? new Date(row.Ship_Date).toISOString().slice(0,10) : '';
                        const prodMon = formatProdMon(row.Ship_Month);
                        const exitDateSortable = row.exit_date ? new Date(row.exit_date).toISOString().slice(0,10) : '';
                        const isExitPast = row.exit_date && new Date(row.exit_date) < new Date();
                        const formattedExitDate = row.exit_date ? formatToDDMMYY(row.exit_date) : '--';
                       
                        const fidate = formatDate(row.FI_Date);
                        const fiDateSortable = row.FI_Date ? new Date(row.FI_Date).toISOString().slice(0,10) : '';

                        // Exit Date Style Logic (Red if past date)
                        
                        let exitDateStyle = '';
                        if (row.exit_date) {
                            const today = moment().startOf('day');
                            const exitDateMoment = moment(row.exit_date, "YYYY-MM-DD").startOf('day');
                            if (exitDateMoment.isBefore(today)) {
                                exitDateStyle = 'color:red;';
                            }
                            else {
                                exitDateStyle = 'color:blue;';
                            }
                        }
                        
                        //console.log("Exit Date Sortable:", exitDateSortable);
                        let selectedUnit = (row.Unit || "").trim();
                        if (selectedUnit === "null" || selectedUnit === "NULL") selectedUnit = "";

                        let allowedEmps =['51052', '51099', '51123','8686','47781','64441'];
                        let currentEmp = "{{ trim(Session::get('empl_id')) }}";
                        let isDisabled = !allowedEmps.includes(currentEmp);
                        let selectedoption = isDisabled ? "readonly" : "";
                        let selectedoption2 = isDisabled ? 'style="pointer-events: none; cursor: not-allowed; color: #888;"' : '';

                        const selectedUnitsArray = selectedUnit ? selectedUnit.split(',').map(u => u.trim()) : [];
                        const buttonText = selectedUnitsArray.length > 0 ? selectedUnit : "Units";

                        const unitSelect = `
                            <div class="dropdown-filter unit-dropdown" data-row-index="${index}">
                                <button class="filter-toggle unit-toggle" title="Select Units" ${selectedoption2}>${buttonText}</button>
                                <div class="checkbox-dropdown-content">
                                    <div class="checkbox-options">
                                        ${units.map(unit => `
                                            <label>
                                                <input type="checkbox" class="unit-checkbox" ${selectedoption}
                                                    value="${unit}" 
                                                    data-itemid="${row.Itemid || ''}" 
                                                    data-colorid="${row.Colorid || ''}"
                                                    ${selectedUnitsArray.includes(unit) ? "checked" : ""}>${unit}
                                                </label>
                                        `).join("")}
                                    </div>
                                </div>
                            </div>
                        `;

                        let statusText = row.status || "--";

                        let factoryexitdate = formatToDDMMYY(row.exit_date);
                        let shipexitdate = moment(row.Ship_Date, "YYYY-MM-DD HH:mm:ss.SSS");
                        let exitDate = moment(row.exit_date, "YYYY-MM-DD");
                        let diffDays = exitDate.diff(shipexitdate, 'days');
                       
                            statusText = row.status || "--";
                        
                        let statusColor = statusText === "On Time" ? "green" : statusText === "Preponed" ? "blue" : statusText === "Postponed" ? "red" : "";

                        const rowHtml = document.createElement('tr');
                        rowHtml.innerHTML = `
                            <td>${row.Buyer || ""}</td>
                            <td style="cursor: pointer; color: blue" data-bs-toggle="modal" data-bs-target="#tableModalproduction" class="production" data-title="production" 
                                data-order-no="GIL-OCN${row.OCN}">${row.OCN}</td>
                            <td class="col-color d-none"></td>
                            <td class="col-item d-none"></td>
                            <td class="text-end">${formatIndianNumber(row.Order_Qty) || ""}</td>
                            <td class="text-end">${row.count ? (row.SAM / row.count).toFixed(2) : ""}</td>
                            <td class="text-end">${formatIndianNumber(row.Bal_To_Sew) || ""}</td>
                            <td class="text-end">${formatIndianNumber(row.Value) || ""}</td>
                            <td class="text-end">${formatIndianNumber(row.Booked_Mins) || ""}</td>
                            <td class="text-center">
                                <span style="display:none">${exitDateSortable}</span>
                                <span class="factory-exit-date" 
                                    style="cursor: ${isDisabled ? 'not-allowed' : 'pointer'}; ${exitDateStyle}"
                                    data-itemid="${row.Itemid || ''}"
                                    data-colorid="${row.Colorid || ''}"
                                    data-empid="${window.emp_id || ''}"
                                    data-shipdate="${shipDate}"
                                    data-ocn="${row.OCN || ''}"
                                    data-prev-exit="${row.pre_exit || ''}"
                                    data-remarks="${row.remarks || ''}"
                                    ${isDisabled ? '' : 'data-bs-toggle="modal" data-bs-target="#exitDateModal"'}
                                >
                                    ${formattedExitDate}
                                </span>
                            </td>

                            <td class="text-center">
                                <span style="display:none">${shipDateSortable}</span>
                                ${shipDate}
                            </td>
                            <td class="text-center">${prodMon}</td>
                            <td class="text-center">
                                <span style="display:none">${fiDateSortable}</span>
                                ${fidate}
                            </td>
                            <td class="text-center">${unitSelect}</td>
                            <td class="text-center" style="color:${statusColor}">${statusText}</td>
                        `;
                        fragment.appendChild(rowHtml);
                    });
                } else {
                    console.time("generateRows");
                    data.forEach(row => {
                        const rowHtml = document.createElement('tr');
                        rowHtml.innerHTML = buildRow(row, units);
                        fragment.appendChild(rowHtml);
                    });
                }

                console.timeEnd("generateRows");
                console.time("updateDOM");
                tbody.innerHTML = "";
                tbody.appendChild(fragment);
                console.timeEnd("updateDOM");

                console.time("initializeDataTable");

                // Custom sorting for Ex Fac Date (already existing)
                $.fn.dataTable.ext.order['date-exfac'] = function(settings, col) {
                    return this.api().column(col).nodes().map(function(td, i) {
                        const sortableDate = $(td).find('span').text().trim();
                        if (sortableDate && sortableDate.match(/^\d{4}-\d{2}-\d{2}$/)) {
                            const date = new Date(sortableDate);
                            return isNaN(date.getTime()) ? 0 : date.getTime();
                        }
                        return 0;
                    });
                };

                // Custom sorting for Ship Date (already existing)
                $.fn.dataTable.ext.order['date-ship'] = function(settings, col) {
                    return this.api().column(col).nodes().map(function(td, i) {
                        const sortableDate = $(td).find('span').text().trim();
                        if (sortableDate && sortableDate.match(/^\d{4}-\d{2}-\d{2}$/)) {
                            const date = new Date(sortableDate);
                            return isNaN(date.getTime()) ? 0 : date.getTime();
                        }
                        return 0;
                    });
                };
                
                $.fn.dataTable.ext.order['date-fi'] = function(settings, col) {
                    return this.api().column(col).nodes().map(function(td, i) {
                        const sortableDate1 = $(td).find('span').first().text().trim();
                        if (sortableDate1 && sortableDate1.match(/^\d{4}-\d{2}-\d{2}$/)) {
                            const date1 = new Date(sortableDate1);
                            return isNaN(date1.getTime()) ? 0 : date1.getTime();
                        }
                        return 0;
                    });
                };

                table = $('#orderTable').DataTable({
                    paging: false,
                    searching: false,
                    ordering: true,
                    info: false,
                    columnDefs: [
                        { targets: [2, 3], visible: !isAggregated },
                        {
                            targets: 9, // Ex Fac Date column
                            orderable: true,
                            type: 'date-exfac'
                        },
                        {
                            targets: isAggregated ? 10 : 10, // Ship Date column
                            orderable: true,
                            type: 'date-ship'
                        },
                        {
                            targets:  12, // FI Date column
                            orderable: true,
                            type: 'date-fi'
                        }
                    ],
                    footerCallback: function(row, data, start, end, display) {
                        let api = this.api();
                        let floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/[\$,L]/g, '')) || 0 : (typeof i === 'number' ? i : 0);

                        let colTotal = (index) => {
                            const columnData = api.column(index, { filter: 'applied' }).data();
                            if (!columnData || columnData.length === 0) return 0;
                            return columnData.reduce((a, b) => floatVal(a) + floatVal(b), 0).toFixed(2);
                        };

                        let col6Total = Math.round(colTotal(6)) || 0;
                        let col7Total = Math.round(colTotal(7)) || 0;
                        let col8Total = colTotal(8) || 0;

                        let col6Lakhs = formatToLakhs(col6Total);
                        let col7Lakhs = formatToLakhs(col7Total);
                        let col8Lakhs = formatToLakhs(col8Total);

                        $(api.column(6).footer()).html(col6Lakhs);
                        $(api.column(7).footer()).html(col7Lakhs);
                        $(api.column(8).footer()).html(col8Lakhs);
                    }
                });

                if (!isAggregated) {
                    $('#orderTable thead th.col-color, #orderTable thead th.col-item').css('display', 'table-cell');
                }

                console.timeEnd("initializeDataTable");

                console.time("initializeFlatpickr");
                document.querySelectorAll(".factory-exit-date").forEach(function(element) {
                    if (element._flatpickr) {
                        element._flatpickr.destroy();
                    }
                });

                const allowedEmps = ["51052", "8686", "47781",'64441'];
                if (allowedEmps.includes(window.emp_id)) {
                    flatpickr("#modalExitDate", {
                        dateFormat: "d/m/y",
                        minDate: "today",
                        maxDate: new Date().fp_incr(365 * 5)
                    });
                } else {
                    document.querySelectorAll(".factory-exit-date").forEach(function(element) {
                        element.style.cursor = 'not-allowed';
                        element.style.color = '#888';
                    });
                }
                console.timeEnd("initializeFlatpickr");

                $("#orderTable tfoot td.col-color-footer, #orderTable tfoot td.col-item-footer").toggle(!isAggregated);
            }

            function triggerUnitChange(dropdown) {
                const row = dropdown.closest('tr')[0];
                const factoryExitInput = row.querySelector('.factory-exit-date');
                const statusCell = $('#aggregatedView').is(':checked') ? row.children[11] : row.children[13];
                const item_id = factoryExitInput ? factoryExitInput.dataset.itemid : null;
                const color_id = factoryExitInput ? factoryExitInput.dataset.colorid : null;
                const emp_id = window.emp_id || null;
                const OCN = factoryExitInput ? factoryExitInput.dataset.ocn : '';
                const exit_date = factoryExitInput ? factoryExitInput.value : null;
                const pre_exit = factoryExitInput ? factoryExitInput.dataset.prevExit : null;
                const rawDate = $('#aggregatedView').is(':checked') ? row.cells[8].textContent.trim() : row.cells[10].textContent.trim();
                const ship_date = rawDate.split('\n')[0].trim();
                const status = statusCell ? statusCell.textContent.trim() : null;
                const selectedUnit = dropdown.find('.unit-checkbox:checked').val() || null;

                //console.log("preexit:", pre_exit);

                //console.log("triggerUnitChange Data:", { OCN, selectedUnit, exit_date, ship_date, status, item_id, color_id, emp_id, pre_exit });

                if (exit_date) {
                    window.originalPlanData.forEach(rowData => {
                        const rowOCNKey = rowData.OCN?.match(/\d+$/) ? rowData.OCN.match(/\d+$/)[0] : (rowData.OCN || "Unknown");
                        if (rowOCNKey === OCN) {
                            rowData.unit = selectedUnit;
                        }
                    });

                    if ($('#aggregatedView').is(':checked')) {
                        saveAggregateOCNToDB({
                            exit_date: exit_date,
                            ship_date: ship_date,
                            status: status,
                            item_id: item_id,
                            color_id: color_id,
                            pre_exit: pre_exit,
                            emp_id: emp_id,
                            OCN: OCN,
                            unit: selectedUnit
                        });
                    } else {
                        saveExitStatusToDB({
                            exit_date: exit_date,
                            ship_date: ship_date,
                            status: status,
                            item_id: item_id,
                            color_id: color_id,
                            pre_exit: pre_exit,
                            emp_id: emp_id,
                            OCN: OCN,
                            unit: selectedUnit
                        });
                    }
                } else {
                    console.warn("Factory exit date missing, cannot save unit.");
                }
            }

            function saveExitStatusToDB({ exit_date, ship_date, status, item_id, color_id, pre_exit, emp_id, OCN, unit, remarks }) {
                $.ajax({
                    url: '/plandataupdate',
                    method: 'POST',
                    data: {
                        exit_date: exit_date,
                        ship_date: ship_date,
                        status: status,
                        item_id: item_id,
                        color_id: color_id,
                        pre_exit: pre_exit,
                        emp_id: emp_id,
                        ocn_no: OCN,
                        unit: unit,
                        remarks: remarks,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        //console.log("saveExitStatusToDB success:", response);
                        if (response.success) {
                            applyFilters();
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("saveExitStatusToDB failed:", { status, error, response: xhr.responseText });
                        alert('Failed to save data. Please try again.');
                    }
                });
            }

            function saveAggregateOCNToDB({ exit_date, ship_date, status, item_id, color_id, pre_exit, emp_id, OCN, unit, remarks }) {
                // Format ship_date and pre_exit to YYYY-MM-DD
                const formattedShipDate = ship_date && moment(ship_date, ['DD/MM/YY', 'DD/MM/YYYY'], true).isValid() 
                    ? moment(ship_date, ['DD/MM/YY', 'DD/MM/YYYY'], true).format('YYYY-MM-DD') 
                    : ship_date || '';
                const formattedPreExit = pre_exit && moment(pre_exit, ['DD/MM/YY', 'DD/MM/YYYY'], true).isValid() 
                    ? moment(pre_exit, ['DD/MM/YY', 'DD/MM/YYYY'], true).format('YYYY-MM-DD') 
                    : pre_exit || '';

                const data = {
                    exit_date: exit_date,
                    ship_date: formattedShipDate, // Formatted to YYYY-MM-DD
                    status: status,
                    item_id: item_id,
                    color_id: color_id,
                    pre_exit: formattedPreExit, // Formatted to YYYY-MM-DD
                    emp_id: emp_id,
                    ocn_no: OCN,
                    unit: unit,
                    remarks: remarks,
                    _token: '{{ csrf_token() }}'
                };
                //("Sending to /aggregateocn:", data);

                $.ajax({
                    url: '/aggregateocn',
                    method: 'POST',
                    data: data,
                    success: function(response) {
                        //console.log("saveAggregateOCNToDB success:", response);
                        if (response.success) {
                            applyFilters();
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("saveAggregateOCNToDB failed:", { status, error, response: xhr.responseText });
                        alert('Failed to save aggregated OCN data. Please try again.');
                    }
                });
            }

            function populateDropdownFilters(data, isAggregated) {
                const columnMap = {
                    0: "Buyer",
                    1: "OCN",
                    2: "Color",
                    3: "Item",
                    13: "Unit",   // Corrected index
                    14: "status"  // Corrected index
                };

                Object.entries(columnMap).forEach(([colIdx, prop]) => {
                    let uniqueValues = [...new Set(data.map(row => {
                        if (colIdx == 1 && row[prop]) {
                            return row[prop].match(/\d+$/) ? row[prop].match(/\d+$/)[0] : row[prop];
                        }
                        if (colIdx == 13) { // Corrected from 10 to 13 for Unit
                            let value = row[prop] || row.Unit_Alloc || "";
                            if (value === "null" || value === "NULL" || value.trim() === "") {
                                return "--";
                            }
                            return value;
                        }
                        if (colIdx == 14) { // Corrected from 12 to 14 for Status
                            let value = row[prop];
                            if (!value || value === "null" || value === "NULL" || value.toString().trim() === "") {
                                return "--";
                            }
                            return value;
                        }
                        return row[prop] || "";
                    }))];

                    if (colIdx == 14 && !uniqueValues.includes("--")) { // Corrected from 12 to 14
                        uniqueValues.push("--");
                    }

                    if (colIdx == 13 && uniqueValues.length === 1 && uniqueValues[0] === "--") { // Corrected from 11 to 13
                        uniqueValues = ["--", ...(window.unitOptions || [])];
                    }

                    uniqueValues = [...new Set(uniqueValues)].sort();

                    const optionsHtml = uniqueValues.map(val => {
                        const trimmed = (val || "").trim();
                        return `<label><input type="checkbox" class="col-filter" value="${trimmed}"> ${trimmed}</label>`;
                    }).join("");

                    if (colIdx == 1) {
                        const searchInputHtml = `
                            <input type="text" class="form-control ocn-search" placeholder="Search OCN..." style="margin-bottom: 8px; font-size: 12px;" />
                        `;
                        $(`.dropdown-filter[data-column="${colIdx}"] .checkbox-dropdown-content`).html(`
                            ${searchInputHtml}
                            <div class="checkbox-dropdown-actions">
                                <button class="select-all">Select All</button>
                                <button class="clear-all">Clear</button>
                            </div>
                            <div class="checkbox-options">${optionsHtml}</div>
                        `);

                        $(`.dropdown-filter[data-column="${colIdx}"] .ocn-search`).on('input', function(e) {
                            e.stopPropagation();
                            const searchTerm = $(this).val().toLowerCase();
                            const $options = $(this).closest('.checkbox-dropdown-content').find('.checkbox-options label');
                            $options.each(function() {
                                const optionText = $(this).text().toLowerCase();
                                $(this).toggle(optionText.includes(searchTerm));
                            });
                        }).on('click', function(e) {
                            e.stopPropagation();
                        }).on('focus', function(e) {
                            e.stopPropagation();
                            $(this).closest('.dropdown-filter').addClass('show');
                        });
                    } else {
                        $(`.dropdown-filter[data-column="${colIdx}"] .checkbox-options`).html(optionsHtml);
                    }
                });
            }

            function parseDate(dateStr) {
                if (!dateStr || dateStr === '--') return null;
                const [day, month, year] = dateStr.split("/").map(Number);
                const fullYear = year < 100 ? 2000 + year : year;
                return new Date(fullYear, month - 1, day);
            }

            function isDateInRange(dateStr, startDateStr, endDateStr) {
                const date = parseDate(dateStr);
                const startDate = parseDate(startDateStr);
                const endDate = parseDate(endDateStr);
                if (!date || !startDate || !endDate) return false;
                return date >= startDate && date <= endDate;
            }

            function applyFilters() {
                if ($.fn.DataTable.isDataTable('#orderTable')) {
                    $('#orderTable').DataTable().destroy();
                    table = null;
                }

                const filters = {};
                $('.dropdown-filter').each(function () {
                    const colIdx = $(this).data('column');
                    filters[colIdx] = $(this).find('input.col-filter:checked').map(function () {
                        return this.value;
                    }).get();
                });

                const factoryExitRange = $('#factoryExitDateRange').val().split(' to ');
                const shippingDateRange = $('#shippingDateRange').val().trim().split(' to ');

                const filteredData = window.originalPlanData.filter(row => {
                    let show = true;

                    if (filters[0] && filters[0].length > 0 && !filters[0].includes(row.Buyer || '')) {
                        show = false;
                    }

                    if (show && filters[1] && filters[1].length > 0) {
                        const ocnValue = row.OCN ? (row.OCN.match(/\d+$/) ? row.OCN.match(/\d+$/)[0] : row.OCN) : '';
                        if (!filters[1].includes(ocnValue)) {
                            show = false;
                        }
                    }

                    if (show && filters[2] && filters[2].length > 0 && !filters[2].includes(row.Color || '')) {
                        show = false;
                    }

                    if (show && filters[3] && filters[3].length > 0 && !filters[3].includes(row.Item || '')) {
                        show = false;
                    }

                    if (show && filters[13] && filters[13].length > 0) { // Corrected from 12 to 13
                        let unitValue = (row.Unit || row.Unit_Alloc || '').trim();
                        if (unitValue === 'null' || unitValue === 'NULL' || unitValue === '') {
                            unitValue = '--';
                        }
                        if ($('#aggregatedView').is(':checked')) {
                            const selectedUnits = unitValue ? unitValue.split(',').map(u => u.trim()) : ['--'];
                            if (!selectedUnits.some(val => filters[13].includes(val))) {
                                show = false;
                            }
                        } else {
                            if (!filters[13].includes(unitValue)) {
                                show = false;
                            }
                        }
                    }

                    if (show && filters[14] && filters[14].length > 0) { // Corrected from 13 to 14
                        let statusValue = row.status || '--';
                        if (!statusValue || statusValue === 'null' || statusValue === 'NULL') {
                            statusValue = '--';
                        }
                        if (!filters[14].includes(statusValue)) {
                            show = false;
                        }
                    }

                    if (show && factoryExitRange[0] && factoryExitRange[1]) {
                        const dateVal = row.exit_date ? formatToDDMMYY(row.exit_date) : '';
                        if (!dateVal || !isDateInRange(dateVal, factoryExitRange[0], factoryExitRange[1])) {
                            show = false;
                        }
                    }

                    if (show && shippingDateRange[0] && shippingDateRange[1]) {
                        const dateVal = formatDate(row.Ship_Date);
                        if (!dateVal || !isDateInRange(dateVal, shippingDateRange[0], shippingDateRange[1])) {
                            show = false;
                        }
                    }

                    return show;
                });

                renderTable(filteredData, $('#aggregatedView').is(':checked'), window.unitOptions);
            }

            function fetchPlanData(capacitytype) {
                $('#orderTableBody').html(`
                    <tr>
                        <td colspan="15" class="text-center text-primary fw-bold py-4">
                            <span class="spinner-border spinner-border-sm me-2"></span>
                            Loading data...
                        </td>
                    </tr>
                `);

                $.ajax({
                    url: "{{ route('macroplandata') }}",
                    method: "GET",
                    data: { capacitytype: capacitytype }, // Pass capacitytype to the backend
                    success: function(response) {
                        originalPlanData = response.data.plandata || [];
                        window.originalPlanData = originalPlanData;
                        const units = (response.data.unitlist || []).map(u => u.Unit);
                        const unit_code = (response.data.unitlist || []).map(u => u.Unit_Code);
                        window.unitOptions = units;
                        window.unitcode = unit_code;

                        console.log("unitsk",window.unitcode);
                       
                        renderTable(originalPlanData, $('#aggregatedView').is(':checked'), units);
                        populateDropdownFilters(originalPlanData, $('#aggregatedView').is(':checked'));
                        applyFilters();
                    },
                    error: function(xhr, status, error) {
                        $('#orderTableBody').html(`
                            <tr>
                                <td colspan="14" class="text-center text-danger fw-bold py-4">
                                    Failed to load data.
                                </td>
                            </tr>
                        `);
                        renderTable(originalPlanData, $('#aggregatedView').is(':checked'), ["G-I", "Unit A", "Unit B"]);
                        populateDropdownFilters(originalPlanData, $('#aggregatedView').is(':checked'));
                        applyFilters();
                    }
                });
            }

            console.log("unit_code",window.unitcode)

            $(document).ready(function() {
                window.emp_id = "{{ $empl_no }}";
                console.log("Employee ID:", window.emp_id);

                flatpickr("#factoryExitDateRange", {
                    mode: "range",
                    dateFormat: "d/m/y",
                    allowInput: true,
                });
                flatpickr("#shippingDateRange", {
                    mode: "range",
                    dateFormat: "d/m/y",
                    allowInput: true
                });

                $(document).on('click', '.filter-toggle', function(e) {
                    e.stopPropagation();
                    $('.dropdown-filter').not($(this).parent()).removeClass('show');
                    $(this).parent().toggleClass('show');
                });

                $(document).on('click', '.unit-toggle', function(e) {
                    e.stopPropagation();
                    const $parent = $(this).parent();
                    $('.dropdown-filter').not($parent).removeClass('show');
                    $parent.addClass('show');
                });

                $(document).on('click', function(e) {
                    if (!$(e.target).closest('.dropdown-filter, .unit-dropdown').length) {
                        $('.dropdown-filter, .unit-dropdown').removeClass('show');
                    }
                });

                $(document).on('click', '.select-all', function(e) {
                    e.stopPropagation();
                    const dropdown = $(this).closest('.dropdown-filter');
                    dropdown.find('input.col-filter').prop('checked', true);
                    applyFilters();
                });

                $(document).on('click', '.clear-all', function(e) {
                    e.stopPropagation();
                    const dropdown = $(this).closest('.dropdown-filter');
                    dropdown.find('input.col-filter').prop('checked', false);
                    const ocnSearchInput = dropdown.find('input.ocn-search');
                    if (ocnSearchInput.length) {
                        ocnSearchInput.val('');
                        dropdown.find('.checkbox-options label').show();
                    }
                    applyFilters();
                });

                $(document).on('change', '.unit-checkbox', function(e) {
                   
                    if ($('#aggregatedView').is(':checked')) {
                        const $dropdown = $(this).closest('.unit-dropdown');
                        const $checkboxes = $dropdown.find('.unit-checkbox');
                        $checkboxes.not(this).prop('checked', false);
                        $(this).prop('checked', true);
                        const selectedUnit = $(this).val();
                        $dropdown.find('.unit-toggle').text(selectedUnit || 'Units');
                        triggerUnitChange($dropdown);
                    }
                });

                $('#factoryExitDateRange, #shippingDateRange').on('change', applyFilters);

                $(document).on('change', '.col-filter', applyFilters);

                $(document).on('click', '.clear-date-range', function(e) {
                    e.stopPropagation();
                    $(this).siblings('input.date-range-filter').val('');
                    applyFilters();
                });

                $("#aggregatedView").on("change", function() {
                    const isChecked = $(this).is(":checked");
                    const $toggleButton = $(this);
                    $("#aggregatedSpinner").show();
                    $toggleButton.prop("disabled", true);
                    setTimeout(() => {
                        if (!Array.isArray(window.originalPlanData) || !Array.isArray(window.unitOptions)) {
                            console.warn("Data or units not loaded yet, skipping renderTable");
                            $("#aggregatedSpinner").hide();
                            $toggleButton.prop("disabled", false);
                            return;
                        }
                        $(".col-color, .col-item").toggle(!isChecked);
                        $("#orderTable thead th.col-color, #orderTable thead th.col-item").css('display', isChecked ? 'none' : 'table-cell');
                        renderTable(window.originalPlanData, isChecked, window.unitOptions);
                        populateDropdownFilters(window.originalPlanData, isChecked);
                        applyFilters();
                        $("#aggregatedSpinner").hide();
                        $toggleButton.prop("disabled", false);
                    }, 0);
                });

                fetchPlanData($('#TypeToggle').is(':checked') ? 'Machine' : 'Strength');
            });

            flatpickr("#monthRangePicker", {
                mode: "single",
                dateFormat: "M Y",
                plugins: [
                    new monthSelectPlugin({
                        shorthand: true,
                        dateFormat: "M Y",
                        altFormat: "F Y"
                    })
                ],
                minDate: moment().add(10, 'months').startOf('month').toDate(),
                onChange: function(selectedDates, dateStr, instance) {
                    if (selectedDates.length === 1) {
                        const end = moment(selectedDates[0]);
                        const start = moment(end).subtract(10, 'months');
                        instance.input.value = `${start.format('MMM YYYY')} - ${end.format('MMM YYYY')}`;
                        const displayMonths = Array.from({ length: 11 }, (_, i) => end.clone().subtract(10 - i, 'months').format('MMM-YY'));
                        const filteredCapdata = capdata.filter(row => {
                            let parsedMoment = moment('1 ' + row.Ship_month, ['D MMMM-YYYY', 'D MMM-YY'], true);
                            if (!parsedMoment.isValid()) return false;
                            return displayMonths.includes(parsedMoment.format('MMM-YY'));
                        });
                        monthwisedetails(filteredCapdata, displayMonths);
                    }
                },
                onMonthChange: function() {
                    this.set('minDate', moment().add(10, 'months').startOf('month').toDate());
                }
            });

            $(document).ready(function() {
                // Replace the .factory-exit-date click handler
                $(document).on('click', '.factory-exit-date', function() {
                    const allowedEmps = ["51052", "8686", "47781", "64441"];
                    if (!allowedEmps.includes(window.emp_id)) {
                        console.log(`Date selection restricted for emp_id: ${window.emp_id}`);
                        return; // Prevent modal for unauthorized users
                    }
                    const $span = $(this);
                    const exitDate = $span.text().trim() === '--' ? '' : $span.text().trim();
                    const remarks = $span.data('remarks') || '';
                    const ocn = $span.data('ocn') || '';
                    const item_id = $span.data('itemid') || '';
                    const color_id = $span.data('colorid') || '';

                    // Set dynamic OCN in modal title
                    $('#modalOCN').text(ocn);
                    $('#modalExitDate').val(exitDate);
                    $('#exitremarks').val(remarks);
                    $('#exitDateModal').data('span', $span); // Store reference to span

                    // Ensure window.unitOptions is an array and populate unit select options
                    const units = Array.isArray(window.unitOptions) && window.unitOptions.length > 0 ? window.unitOptions : [];
                    if (units.length === 0) {
                        console.warn("No unit options available. Ensure window.unitOptions is populated correctly.");
                    }
                    $('#modalUnitSelect').html(`
                        <option value="">Select Unit</option>
                        ${units.map(unit => `
                            <option value="${unit}">${unit}</option>
                        `).join('')}
                    `);

                    // Fetch and populate history
                    $.ajax({
                        url: '/fetchExitDateHistory',
                        method: 'GET',
                        data: { ocn: ocn, item_id: item_id, color_id: color_id },
                        success: function(response) {
                            const history = response.data || [];
                            let historyHtml = '';
                            history.forEach((entry, index) => {
                                historyHtml += `
                                    <tr>
                                        <td>${entry.exit_date ? formatToDDMMYY(entry.exit_date) : '--'}</td>
                                        <td>${entry.unit || '--'}</td>
                                        <td>${entry.remarks || '--'}</td>
                                        <td>${entry.plan_qty !== null ? entry.plan_qty : '--'}</td>
                                        <td>${entry.Name || '--'}</td>
                                    </tr>
                                `;
                            });
                            $('#exitDateHistoryBody').html(historyHtml || '<tr><td colspan="5" class="text-center">No history available</td></tr>');
                        },
                        error: function(xhr, status, error) {
                            console.error('Failed to fetch history:', { status, error, response: xhr.responseText });
                            $('#exitDateHistoryBody').html('<tr><td colspan="5" class="text-center">Failed to load history</td></tr>');
                        }
                    });
                });

                // Replace the #saveExitDate handler
                // $('#saveExitDate').on('click', function() {
                //     const $span = $('#exitDateModal').data('span');
                //     if (!$span) return;

                //     const factoryDateStr = $('#modalExitDate').val().trim();
                //     const remarks = $('#exitremarks').val().trim();
                //     const selectedUnit = $('#modalUnitSelect').val();
                //     const row = $span.closest('tr')[0];
                //     const shipDateCell = $('#aggregatedView').is(':checked') ? row.cells[8] : row.cells[10];
                //     const statusCell = $('#aggregatedView').is(':checked') ? row.cells[12] : row.cells[14];
                //     const item_id = $span.data('itemid');
                //     const color_id = $span.data('colorid');
                //     const emp_id = $span.data('empid') || '';
                //     const OCN = $span.data('ocn') || '';
                //     const pre_exit = $span.data('prev-exit') || '';
                //     const rawDate = shipDateCell.textContent.trim();
                //     let ship_date = rawDate.split('\n')[0].trim();

                //     // Format ship_date to YYYY-MM-DD for aggregated view
                //     if ($('#aggregatedView').is(':checked')) {
                //         const parsedShipDate = moment(ship_date, ['DD/MM/YY', 'DD/MM/YYYY'], true);
                //         ship_date = parsedShipDate.isValid() ? parsedShipDate.format('YYYY-MM-DD') : ship_date;
                //     }

                //     //console.log("ship_date:", ship_date);
                //     //console.log("exit_date:", factoryDateStr);
                //     //console.log(row);
                //     //console.log("span:", $span);
                //     //console.log("pre_exit:", $span.data('prevExit'));

                //     if (factoryDateStr && ship_date) {
                //         // Parse dates with explicit formats
                //         const factoryDate = moment(factoryDateStr, ['DD/MM/YY', 'DD/MM/YYYY'], true);
                //         const shipDate = moment(ship_date, ['YYYY-MM-DD', 'DD/MM/YY', 'DD/MM/YYYY'], true);

                //        // console.log("factoryDate:", factoryDate);   
                //         //console.log("shipDate:", shipDate);
                //         if (!factoryDate.isValid() || !shipDate.isValid()) {
                //             console.warn('Invalid date format:', factoryDateStr, ship_date);
                //             if (statusCell) {
                //                 statusCell.textContent = 'Invalid Date';
                //                 statusCell.style.color = 'orange';
                //             }
                //             alert('Invalid date format. Please select a valid date.');
                //             return;
                //         }

                //         $('#exitDateModal').modal('hide');

                //         const diffDays = shipDate.diff(factoryDate, 'days');
                //         let statusText = '';
                //         let statusColor = '';

                //         if (diffDays >= 0 && diffDays <= 6) {
                //             statusText = 'On Time';
                //             statusColor = 'green';
                //         } else if (diffDays > 6) {
                //             statusText = 'Preponed';
                //             statusColor = 'blue';
                //         } else {
                //             statusText = 'Postponed';
                //             statusColor = 'red';
                //         }

                //         if (statusCell) {
                //             statusCell.textContent = statusText;
                //             statusCell.style.color = statusColor;
                //         } else {
                //             console.warn('Status cell not found for row:', row);
                //         }

                //         $span.text(factoryDateStr || '--');
                //         $span.data('remarks', remarks);

                //         // Update unit select in the table row
                //         const unitSelect = row.querySelector('.unit-select');
                //         if (unitSelect) {
                //             unitSelect.value = selectedUnit || '';
                //             unitSelect.dataset.previousValue = selectedUnit || '';
                //         }

                //         window.originalPlanData.forEach(rowData => {
                //             const rowOCNKey = rowData.OCN?.match(/\d+$/) ? rowData.OCN.match(/\d+$/)[0] : (rowData.OCN || "Unknown");
                //             if (rowOCNKey === OCN) {
                //                 rowData.exit_date = factoryDate.format('YYYY-MM-DD');
                //                 rowData.status = statusText;
                //                 rowData.remarks = remarks;
                //                 rowData.Unit = selectedUnit || '';
                //             }
                //         });

                //         const data = {
                //             exit_date: factoryDate.format('YYYY-MM-DD'),
                //             ship_date: ship_date,
                //             status: statusText,
                //             item_id: item_id,
                //             color_id: color_id,
                //             pre_exit: pre_exit,
                //             emp_id: emp_id,
                //             ocn_no: OCN,
                //             unit: selectedUnit,
                //             remarks: remarks,
                //             _token: '{{ csrf_token() }}'
                //         };

                //         //console.log("Saving exit date selection:", data);

                //         // Append to history table before saving to DB
                //         const $historyBody = $('#exitDateHistoryBody');
                //         const currentEntries = $historyBody.find('tr').length;
                //         const newRow = `
                //             <tr>
                //                 <td>${factoryDateStr || '--'}</td>
                //                 <td>${selectedUnit || '--'}</td>
                //                 <td>${remarks || '--'}</td>
                //                 <td>${window.emp_id || '--'}</td>
                //             </tr>
                //         `;
                //         if (currentEntries === 1 && $historyBody.find('tr td').text().includes('No history available')) {
                //             $historyBody.empty();
                //         }
                //         $historyBody.append(newRow);

                //         // Clear the input fields
                //         $('#modalExitDate').val('');
                //         $('#modalUnitSelect').val('');
                //         $('#exitremarks').val('');

                //         $.ajax({
                //             url: $('#aggregatedView').is(':checked') ? '/aggregateocn' : '/plandataupdate',
                //             method: 'POST',
                //             data: data,
                //             success: function(response) {
                //                 //console.log("Exit date save success:", response);
                //                 // Treat 'Data Updated successfully' as a successful response
                //                 if (response.success || response.message === 'Data Updated successfully') {
                //                     // Show Bootstrap toast with dynamic OCN
                //                     const toastEl = document.getElementById('efdToast');
                //                     const toastBody = toastEl.querySelector('.toast-body');
                //                     toastBody.textContent = `EFD updated successfully for ${OCN}`;
                //                     const toast = new bootstrap.Toast(toastEl, {
                //                         autohide: true,
                //                         delay: 3000 // 3 seconds
                //                     });
                //                     toast.show();
                //                     //applyFilters();
                //                 } else {
                //                     console.warn("Save succeeded but unexpected response:", response);
                //                     alert('Exit date saved but no changes applied. Please check the data.');
                //                     // Remove the appended row if success condition fails
                //                     $historyBody.find('tr:last').remove();
                //                     if ($historyBody.find('tr').length === 0) {
                //                         $historyBody.html('<tr><td colspan="4" class="text-center">No history available</td></tr>');
                //                     }
                //                 }
                //             },
                //             error: function(xhr, status, error) {
                //                 console.error("Exit date save failed:", { status, error, response: xhr.responseText });
                //                 alert('Failed to save exit date. Please try again.');
                //                 // Remove the appended row if DB save fails
                //                 $historyBody.find('tr:last').remove();
                //                 if ($historyBody.find('tr').length === 0) {
                //                     $historyBody.html('<tr><td colspan="4" class="text-center">No history available</td></tr>');
                //                 }
                //             }
                //         });

                //         $span.data('prevExit', factoryDateStr);
                //     } else {
                //         console.warn("Factory exit date missing, cannot save.");
                //         alert("Please select Factory Exit Date to proceed.");
                //     }
                // });
            });
  
</script>

    <script>
        $(document).ready(function() {
            let originalBalToSew = 0;
            let currentOCN = '';
            let remainingQty = 0;

            // Function to update total units display
            function updateTotalUnits() {
                const inputs = $('.qty-input');
                let total = 0;
                inputs.each(function() {
                    total += parseInt($(this).val()) || 0;
                });
                $('#totalUnits').text(total.toString().padStart(4, '0')); // Display with leading zeros (e.g., 0000)
            }

            // Modified createSplitInputs function
            function createSplitInputs(count) {
                const unitContainer = $('#unitSelectorsContainer');
                const balContainer = $('#bal_unitsContainer');
                const unitOptions = window.unitOptions || [];
                const unitcode = window.unitOptions || [];
                
                unitContainer.empty();
                balContainer.empty();
                
                // Calculate base quantity per split
                const baseQty = Math.floor(originalBalToSew / count);
                remainingQty = originalBalToSew % count;
                
                for (let i = 1; i <= count; i++) {
                    // Calculate quantity for this split (distribute remainder)
                    let qty = baseQty;
                    if (i <= remainingQty) {
                        qty += 1;
                    }
                    
                    // Create unit selector
                    unitContainer.append(`
                        <div class="mb-2">
                            <label for="unitSelect${i}" class="form-label small">
                            <strong> Unit ${i}</strong>
                            </label>
                            <select class="form-select form-select-sm unit-dropdown" id="unitSelect${i}" data-index="${i}">
                                <option value="">Select Unit</option>
                                ${unitOptions.map(unit => 
                                    `<option value="${unit}">${unit}</option>`
                                ).join('')}
                            </select>
                        </div>
                    `);
                    
                    // Create editable quantity input
                    balContainer.append(`
                        <div class="mb-2">
                            <label class="form-label small">
                            <strong> Qty ${i} </strong>
                            </label>
                            <input type="number" class="form-control qty-input" id="qtyInput${i}" 
                                value="${qty}" min="0" max="${originalBalToSew}" 
                                data-original="${qty}" data-index="${i}">
                        </div>
                    `);
                }
                
                // Add event listeners for quantity inputs
                $('.qty-input').on('input', function() {
                    adjustQuantities($(this));
                    updateTotalUnits(); // Update total units on input change
                });
                
                updateTotalUnits(); // Update total units after creating inputs
            }

            // Modified adjustQuantities function
            function adjustQuantities(changedInput) {
                const inputs = $('.qty-input');
                const index = parseInt(changedInput.data('index'));
                let total = 0;
                
                // Validate the changed input
                let currentVal = parseInt(changedInput.val()) || 0;
                if (currentVal < 0) {
                    currentVal = 0;
                    changedInput.val(0);
                } else if (currentVal > originalBalToSew) {
                    currentVal = originalBalToSew;
                    changedInput.val(originalBalToSew);
                }
                
                // Calculate current total
                inputs.each(function() {
                    total += parseInt($(this).val()) || 0;
                });
                
                // Adjust quantities to match originalBalToSew
                if (total !== originalBalToSew) {
                    const diff = originalBalToSew - total; // Positive if we need to add, negative if we need to subtract
                    let remainingAdjustment = Math.abs(diff);
                    const isAdding = diff > 0;

                    // Start adjusting from the next input, excluding the changed input
                    for (let i = 1; i <= inputs.length && remainingAdjustment > 0; i++) {
                        if (i === index) continue; // Skip the changed input
                        const currentInput = $(`#qtyInput${i}`);
                        let currentInputVal = parseInt(currentInput.val()) || 0;
                        
                        if (isAdding) {
                            // Add remaining quantity to successive fields
                            const addAmount = Math.min(remainingAdjustment, originalBalToSew - currentInputVal);
                            currentInput.val(currentInputVal + addAmount);
                            remainingAdjustment -= addAmount;
                        } else {
                            // Subtract excess quantity from successive fields
                            const subtractAmount = Math.min(remainingAdjustment, currentInputVal);
                            currentInput.val(currentInputVal - subtractAmount);
                            remainingAdjustment -= subtractAmount;
                        }
                    }
                    
                    // If still need adjustment, wrap around to other inputs (excluding changed input)
                    if (remainingAdjustment > 0) {
                        for (let i = 1; i <= inputs.length && remainingAdjustment > 0; i++) {
                            if (i === index) continue; // Skip the changed input
                            const currentInput = $(`#qtyInput${i}`);
                            let currentInputVal = parseInt(currentInput.val()) || 0;
                            
                            if (isAdding) {
                                const addAmount = Math.min(remainingAdjustment, originalBalToSew - currentInputVal);
                                currentInput.val(currentInputVal + addAmount);
                                remainingAdjustment -= addAmount;
                            } else {
                                const subtractAmount = Math.min(remainingAdjustment, currentInputVal);
                                currentInput.val(currentInputVal - subtractAmount);
                                remainingAdjustment -= subtractAmount;
                            }
                        }
                    }
                }
                
                // Ensure no negative values and update max attributes
                inputs.each(function() {
                    let val = parseInt($(this).val()) || 0;
                    if (val < 0) {
                        $(this).val(0);
                    }
                    // Update max attribute to prevent exceeding remaining balance
                    $(this).attr('max', originalBalToSew);
                });
                
                updateTotalUnits(); // Update total units after adjustments
            }

            $(document).on('change', '.unit-dropdown', function () {
                const selectedUnit = $(this).val();
                const currentIndex = $(this).data('index');

                // 👉 Get the index of selected unit from unitOptions
                const unitOptions = window.unitOptions || [];
                const unitCodes = window.unitcode || [];

                const selectedIndex = unitOptions.indexOf(selectedUnit);
                const matchingUnitCode = unitCodes[selectedIndex];

                if (selectedUnit) {
                    console.log(`✅ Unit selected: ${selectedUnit}, Code: ${matchingUnitCode}`);

                    // Disable this option in other dropdowns
                    $('.unit-dropdown').not(this).find(`option[value="${selectedUnit}"]`).prop('disabled', true);

                    $('.unit-dropdown').not(this).each(function () {
                        if ($(this).val() === selectedUnit) {
                            $(this).val('');
                        }
                    });
                }

                const prevValue = $(this).data('prev-value');
                if (prevValue) {
                    $('.unit-dropdown').not(this).find(`option[value="${prevValue}"]`).prop('disabled', false);
                }

                $(this).data('prev-value', selectedUnit);
            });


            // Update total units when modal is shown
            $(document).on('click', '.factory-exit-date', function() {
                const allowedEmps = ["51052", "8686", "47781", "64441"];
                if (!allowedEmps.includes(window.emp_id)) {
                    console.log(`Date selection restricted for emp_id: ${window.emp_id}`);
                    return;
                }
                
                const $span = $(this);
                const $row = $span.closest('tr');
                originalBalToSew = parseInt($row.find('td').eq(6).text().replace(/,/g, '')) || 0;
                currentOCN = $span.data('ocn') || '';
                
                $('#modalOCN').text(currentOCN);
                $('#modalExitDate').val($span.text().trim() === '--' ? '' : $span.text().trim());
                $('#exitremarks').val($span.data('remarks') || '');
                $('#exitDateModal').data('span', $span);
                
                $('#splitQuantity').val(1).trigger('change');
                updateTotalUnits(); // Update total units when modal is shown
            });

            // Split quantity change handler
            $('#splitQuantity').on('change', function() {
                let count = parseInt($(this).val()) || 1;
                count = Math.max(1, Math.min(count, 5));
                createSplitInputs(count);
            });

            // Increment/decrement buttons for split quantity
            $('#incrementSplit').on('click', function() {
                const input = $('#splitQuantity');
                let value = parseInt(input.val()) || 1;
                if (value < 5) {
                    input.val(value + 1).trigger('change');
                }
            });

            $('#decrementSplit').on('click', function() {
                const input = $('#splitQuantity');
                let value = parseInt(input.val()) || 1;
                if (value > 1) {
                    input.val(value - 1).trigger('change');
                }
            });

            // Save exit date handler
            $('#saveExitDate').on('click', function() {
                const $span = $('#exitDateModal').data('span');
                if (!$span) return;

                const factoryDateStr = $('#modalExitDate').val().trim();
                const remarks = $('#exitremarks').val().trim();
                const row = $span.closest('tr')[0];
                const shipDateCell = $('#aggregatedView').is(':checked') ? row.cells[8] : row.cells[10];
                const statusCell = $('#aggregatedView').is(':checked') ? row.cells[12] : row.cells[14];
                const item_id = $span.data('itemid');
                const color_id = $span.data('colorid');
                const emp_id = $span.data('empid') || '';
                const OCN = $span.data('ocn') || '';
                const pre_exit = $span.data('prev-exit') || '';
                const rawDate = shipDateCell.textContent.trim();
                let ship_date = rawDate.split('\n')[0].trim();

                // Format ship_date to YYYY-MM-DD for aggregated view
                if ($('#aggregatedView').is(':checked')) {
                    const parsedShipDate = moment(ship_date, ['DD/MM/YY', 'DD/MM/YYYY'], true);
                    ship_date = parsedShipDate.isValid() ? parsedShipDate.format('YYYY-MM-DD') : ship_date;
                }

                if (factoryDateStr && ship_date) {
                    // Parse dates with explicit formats
                    const factoryDate = moment(factoryDateStr, ['DD/MM/YY', 'DD/MM/YYYY'], true);
                    const shipDate = moment(ship_date, ['YYYY-MM-DD', 'DD/MM/YY', 'DD/MM/YYYY'], true);

                    if (!factoryDate.isValid() || !shipDate.isValid()) {
                        console.warn('Invalid date format:', factoryDateStr, ship_date);
                        if (statusCell) {
                            statusCell.textContent = 'Invalid Date';
                            statusCell.style.color = 'orange';
                        }
                        alert('Invalid date format. Please select a valid date.');
                        return;
                    }

                    // Collect split data
                    const splitCount = parseInt($('#splitQuantity').val()) || 1;
                    const splitData = [];
                    let totalQty = 0;
                    for (let i = 1; i <= splitCount; i++) {
                        const unit = $(`#unitSelect${i}`).val();
                        const qty = parseInt($(`#qtyInput${i}`).val()) || 0;
                        if (unit && qty > 0) {
                            splitData.push({
                                unit: unit,
                                quantity: qty
                            });
                            totalQty += qty;
                        }
                    }

                    // Validate total quantity matches originalBalToSew
                    if (totalQty !== originalBalToSew) {
                        alert('Total split quantities must equal the original balance to sew (' + originalBalToSew + '). Current total: ' + totalQty);
                        return;
                    }

                    // Validate that all splits have a unit selected
                    if (splitData.length !== splitCount) {
                        alert('Please select a unit and valid quantity for all splits.');
                        return;
                    }

                    $('#exitDateModal').modal('hide');

                    const diffDays = shipDate.diff(factoryDate, 'days');
                    let statusText = '';
                    let statusColor = '';

                    if (diffDays >= 0 && diffDays <= 6) {
                        statusText = 'On Time';
                        statusColor = 'green';
                    } else if (diffDays > 6) {
                        statusText = 'Preponed';
                        statusColor = 'blue';
                    } else {
                        statusText = 'Postponed';
                        statusColor = 'red';
                    }

                    if (statusCell) {
                        statusCell.textContent = statusText;
                        statusCell.style.color = statusColor;
                    } else {
                        console.warn('Status cell not found for row:', row);
                    }

                    $span.text(factoryDateStr || '--');
                    $span.data('remarks', remarks);

                    // Update unit select in the table row (use first unit for display)
                    const unitSelect = row.querySelector('.unit-select');
                    if (unitSelect && splitData.length > 0) {
                        unitSelect.value = splitData[0].unit || '';
                        unitSelect.dataset.previousValue = splitData[0].unit || '';
                    }

                    // Update originalPlanData with first split's data for display
                    window.originalPlanData.forEach(rowData => {
                        const rowOCNKey = rowData.OCN?.match(/\d+$/) ? rowData.OCN.match(/\d+$/)[0] : (rowData.OCN || "Unknown");
                        if (rowOCNKey === OCN) {
                            rowData.exit_date = factoryDate.format('YYYY-MM-DD');
                            rowData.status = statusText;
                            rowData.remarks = remarks;
                            rowData.Unit = splitData[0].unit || '';
                        }
                    });

                    // Append to history table for each split
                    const $historyBody = $('#exitDateHistoryBody');
                    const currentEntries = $historyBody.find('tr').length;
                    if (currentEntries === 1 && $historyBody.find('tr td').text().includes('No history available')) {
                        $historyBody.empty();
                    }
                    const newRows = splitData.map(split => `
                        <tr>
                            <td>${factoryDateStr || '--'}</td>
                            <td>${split.unit || '--'}</td>
                            <td>${split.quantity || '--'}</td>
                            <td>${remarks || '--'}</td>
                            <td>${window.emp_id || '--'}</td>
                        </tr>
                    `);
                    $historyBody.append(newRows.join(''));

                    // Clear the input fields
                    $('#modalExitDate').val('');
                    $('#splitQuantity').val(1).trigger('change');
                    $('#exitremarks').val('');

                    // Send separate AJAX calls for each split
                    let successCount = 0;
                    const totalSplits = splitData.length;

                  

                    splitData.forEach((split, index) => {

                        // 🧠 Get unit code based on selected unit
                        const unitOptions = window.unitOptions || [];
                        const unitCodes = window.unitcode || [];

                        const unitIndex = unitOptions.indexOf(split.unit);
                        const unit_code = unitCodes[unitIndex] || ''; // fallback to '' if not found


                        const data = {
                            exit_date: factoryDate.format('YYYY-MM-DD'),
                            ship_date: ship_date,
                            status: statusText,
                            item_id: item_id,
                            color_id: color_id,
                            pre_exit: pre_exit,
                            emp_id: emp_id,
                            ocn_no: OCN,
                            unit: split.unit,
                            unit_code: unit_code, 
                            quantity: split.quantity,
                            remarks: remarks,
                            _token: '{{ csrf_token() }}'
                        };

                        console.log(`🚀 Sending unit: ${split.unit}, code: ${unit_code}`);


                        $.ajax({
                            url: $('#aggregatedView').is(':checked') ? '/aggregateocn' : '/plandataupdate',
                            method: 'POST',
                            data: data,
                            success: function(response) {
                                if (response.success || response.message === 'Data Updated successfully') {
                                    successCount++;
                                    if (successCount === totalSplits) {
                                        const toastEl = document.getElementById('efdToast');
                                        const toastBody = toastEl.querySelector('.toast-body');
                                        toastBody.textContent = `EFD updated successfully for ${OCN} with ${totalSplits} split(s)`;
                                        const toast = new bootstrap.Toast(toastEl, {
                                            autohide: true,
                                            delay: 3000
                                        });
                                        toast.show();
                                    }
                                } else {
                                    console.warn(`Save succeeded but unexpected response for split ${index + 1}:`, response);
                                    alert(`Exit date saved for split ${index + 1} but no changes applied. Please check the data.`);
                                    // Remove the corresponding history row
                                    $historyBody.find('tr').eq(currentEntries + index).remove();
                                    if ($historyBody.find('tr').length === 0) {
                                        $historyBody.html('<tr><td colspan="5" class="text-center">No history available</td></tr>');
                                    }
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error(`Exit date save failed for split ${index + 1}:`, { status, error, response: xhr.responseText });
                                alert(`Failed to save exit date for split ${index + 1}. Please try again.`);
                                // Remove the corresponding history row
                                $historyBody.find('tr').eq(currentEntries + index).remove();
                                if ($historyBody.find('tr').length === 0) {
                                    $historyBody.html('<tr><td colspan="5" class="text-center">No history available</td></tr>');
                                }
                            }
                        });
                    });

                    $span.data('prevExit', factoryDateStr);
                } else {
                    console.warn("Factory exit date missing, cannot save.");
                    alert("Please select Factory Exit Date to proceed.");
                }
            });
            $(document).ready(function() {
                // Toggle history table visibility
                $('.toggle-history').on('click', function() {
                    const $historyContainer = $('.history-table-container');
                    const isHidden = $historyContainer.is(':hidden');
                    $historyContainer.slideToggle(300); // Smooth toggle animation
                    $(this).text(isHidden ? 'Hide history' : 'View history'); // Update text
                });
            });
        });
    </script>



    <script>
        $(document).on('click', '.cap-month-cell, .cap-total-cell', function() {
            const month = $(this).data('month') || ''; // Empty string for total cells
            const factory = $(this).data('factory');
            const isTotalCell = $(this).hasClass('cap-total-cell'); // Check if it's a total cell
            const isGrandTotalCell = factory === '' && isTotalCell; // Check if it's the grand total cell
            const isFactoryTotalCell = month === 'overall' && !isGrandTotalCell; // Check if it's a factory total cell

            

            // Destroy existing DataTable
            if ($.fn.DataTable.isDataTable('#orderTable')) {
                let table = $('#orderTable').DataTable();
                table.clear().destroy();
            }
            $('#orderTable_wrapper').remove();

            // Show loading state in orderTableBody
            $('#orderTableBody').html(`
                <tr>
                    <td colspan="15" class="text-center text-primary fw-bold py-4">
                        <span class="spinner-border spinner-border-sm me-2"></span>
                        Loading data...
                    </td>
                </tr>
            `);

            // Determine factory name and display text
            let name = '';
            let displayText = '';
            if (isGrandTotalCell) {
                name = 'Total';
                displayText = 'All Factories (All Months)';
            } else {
                if (factory == 3) {
                    name = 'Alamelu';
                } else if (factory == 12) {
                    name = 'Gainup';
                } else {
                    name = 'Total';
                }
                if (isTotalCell || isFactoryTotalCell) {
                    displayText = `Factory: ${name} (All Months)`;
                } else {
                    let displayMonth = '';
                    if (month) {
                        let match = month.match(/([A-Za-z]+)/);
                        displayMonth = match ? match[1].toUpperCase() : month.toString().toUpperCase();
                    }
                    displayText = factory == 3 || factory == 12 ? `Month: ${displayMonth} - Factory: ${name}` : `Month: ${displayMonth}`;
                }
            }
            $('#selectedMonthText').text(displayText);

            // Show toast notification
            const toast = new bootstrap.Toast(document.getElementById('clickToast'));
            $('#clickToast .toast-body').text(`Clicked: ${displayText}`);
            toast.show();

            // AJAX call to fetch data
            $.ajax({
                url: "{{ route('macroplandata') }}",
                method: "GET",
                data: isGrandTotalCell || isFactoryTotalCell ? { unit: factory } : { month: isTotalCell ? '' : month, unit: factory }, // Send only unit for factory total
                success: function(response) {
                    if ($.fn.DataTable.isDataTable('#orderTable')) {
                        $('#orderTable').DataTable().destroy();
                    }
                    $("#preloder").fadeOut();
                    originalPlanData = response.data.plandata || [];
                    const units = (response.data.unitlist || []).map(u => u.unit);

                    window.originalPlanData = originalPlanData;
                    renderTable(originalPlanData, $('#aggregatedView').is(':checked'), units);
                    populateDropdownFilters(originalPlanData, $('#aggregatedView').is(':checked'));
                    applyFilters();

                    // Initialize Flatpickr for .factory-exit-date inputs
                    // flatpickr(".factory-exit-date", {
                    //     dateFormat: "d/m/y",
                    //     minDate: "today",
                    //     maxDate: new Date().fp_incr(365 * 5)
                    // });

                    // Re-attach event handlers
                    $(document).off('change', '.factory-exit-date').on('change', '.factory-exit-date', function() {
                        const row = $(this).closest('tr')[0];
                        const shipDateCell = $('#aggregatedView').is(':checked') ? row.cells[8] : row.cells[10];
                        const statusCell = $('#aggregatedView').is(':checked') ? row.cells[12] : row.cells[14];
                        const factoryDateStr = this.value;

                        const shipDateStr = $(shipDateCell).contents().filter(function() {
                            return this.nodeType === 3;
                        }).text().trim().replace(/--$/, '');

                        const pre_exit = this.dataset.prevExit || "";
                        const item_id = this.dataset.itemid;
                        const color_id = this.dataset.colorid;
                        const emp_id = this.dataset.empid;
                        const OCN = this.dataset.ocn || '';
                        const unit = row.querySelector('.unit-select') ? row.querySelector('.unit-select').value : '';

                        if (factoryDateStr && shipDateStr) {
                            const factoryDate = moment(factoryDateStr, ['DD/MM/YY', 'DD/MM/YYYY'], true);
                            const shipDate = moment(shipDateStr, ['DD/MM/YY', 'DD/MM/YYYY'], true);

                            if (!factoryDate.isValid() || !shipDate.isValid()) {
                                console.warn('Invalid date format:', factoryDateStr, shipDateStr);
                                if (statusCell) {
                                    statusCell.textContent = 'Invalid Date';
                                    statusCell.style.color = 'orange';
                                }
                                return;
                            }

                            const diffDays = shipDate.diff(factoryDate, 'days');
                            let statusText = '';
                            let statusColor = '';

                            if (diffDays >= 0 && diffDays <= 6) {
                                statusText = 'On Time';
                                statusColor = 'green';
                            } else if (diffDays > 6) {
                                statusText = 'Preponed';
                                statusColor = 'blue';
                            } else {
                                statusText = 'Postponed';
                                statusColor = 'red';
                            }

                            if (statusCell) {
                                statusCell.textContent = statusText;
                                statusCell.style.color = statusColor;
                            } else {
                                console.warn('Status cell not found for row:', row);
                            }

                            // Update originalPlanData for all rows with matching OCN
                            window.originalPlanData.forEach(rowData => {
                                const rowOCNKey = rowData.OCN?.match(/\d+$/) ? rowData.OCN.match(/\d+$/)[0] : (rowData.OCN || "Unknown");
                                if (rowOCNKey === OCN) {
                                    rowData.exit_date = factoryDateStr;
                                    rowData.status = statusText;
                                }
                            });

                            if ($('#aggregatedView').is(':checked')) {
                                saveAggregateOCNToDB({
                                    exit_date: factoryDateStr,
                                    ship_date: shipDateStr,
                                    status: statusText,
                                    item_id: item_id,
                                    color_id: color_id,
                                    pre_exit: pre_exit,
                                    emp_id: emp_id,
                                    OCN: OCN,
                                    unit: unit
                                });
                            } else {
                                saveExitStatusToDB({
                                    exit_date: factoryDateStr,
                                    ship_date: shipDateStr,
                                    status: statusText,
                                    item_id: item_id,
                                    color_id: color_id,
                                    pre_exit: pre_exit,
                                    emp_id: emp_id,
                                    OCN: OCN,
                                    unit: unit
                                });
                            }

                            this.dataset.prevExit = factoryDateStr;
                        }
                    });

                    $(document).off('change', '.unit-select').on('change', '.unit-select', function() {
                        const allowedEmps = ["51052", "8686","47781",'64441'];
                        if (allowedEmps.includes(window.emp_id)) {
                            console.log(`Unit selection restricted for emp_id: ${window.emp_id}`);
                            this.value = this.dataset.previousValue || '';
                            return;
                        }

                        const selectedUnit = this.value;
                        this.dataset.previousValue = selectedUnit;
                        $(this).val(selectedUnit);

                        const row = $(this).closest('tr')[0];
                        const factoryExitInput = row.querySelector('.factory-exit-date');
                        const statusCell = $('#aggregatedView').is(':checked') ? row.cells[12] : row.cells[14];
                        const item_id = this.dataset.itemid;
                        const color_id = this.dataset.colorid;
                        const emp_id = window.emp_id || '';
                        const OCN = factoryExitInput ? factoryExitInput.dataset.ocn : '';
                        const exit_date = factoryExitInput ? factoryExitInput.value : '';
                        const rawDate = $('#aggregatedView').is(':checked') ? row.cells[8].textContent.trim() : row.cells[10].textContent.trim();
                        const ship_date = rawDate.split('\n')[0].trim();
                        const status = statusCell ? statusCell.textContent.trim() : '';

                        window.originalPlanData.forEach(rowData => {
                            const rowOCNKey = rowData.OCN?.match(/\d+$/) ? rowData.OCN.match(/\d+$/)[0] : (rowData.OCN || "Unknown");
                            if (rowOCNKey === OCN) {
                                rowData.Unit = selectedUnit;
                            }
                        });

                        if (exit_date) {
                            const data = {
                                exit_date: exit_date,
                                ship_date: ship_date,
                                status: status,
                                item_id: item_id,
                                color_id: color_id,
                                pre_exit: "",
                                emp_id: emp_id,
                                ocn_no: OCN,
                                unit: selectedUnit,
                                _token: '{{ csrf_token() }}'
                            };

                            console.log("Saving unit selection:", data);

                            $.ajax({
                                url: $('#aggregatedView').is(':checked') ? '/aggregateocn' : '/plandataupdate',
                                method: 'POST',
                                data: data,
                                success: function(response) {
                                    console.log("Unit save success:", response);
                                    if (response.success) {
                                        applyFilters();
                                    } else {
                                        console.warn("Save succeeded but success flag is false:", response);
                                        alert('Unit saved but no changes applied. Please check the data.');
                                    }
                                },
                                error: function(xhr, status, error) {
                                    console.error("Unit save failed:", { status, error, response: xhr.responseText });
                                    alert('Failed to save unit. Please try again.');
                                }
                            });
                        } else {
                            console.warn("Factory exit date missing, cannot save unit.");
                            alert("Please select Factory Exit Date first to update unit.");
                            applyFilters();
                        }
                    });

                    $('.filter-toggle').off('click').on('click', function(e) {
                        e.stopPropagation();
                        $('.dropdown-filter').not($(this).parent()).removeClass('show');
                        $(this).parent().toggleClass('show');
                    });

                    $(document).off('click.dropdownfilter').on('click.dropdownfilter', function() {
                        $('.dropdown-filter').removeClass('show');
                    });

                    $('.select-all').off('click').on('click', function(e) {
                        e.stopPropagation();
                        const dropdown = $(this).closest('.dropdown-filter');
                        dropdown.find('input.col-filter').prop('checked', true);
                        applyFilters(); // Rerender table with updated filters
                    });

                    $('.clear-all').off('click').on('click', function(e) {
                        e.stopPropagation();
                        const dropdown = $(this).closest('.dropdown-filter');
                        dropdown.find('input.col-filter').prop('checked', false);
                        const searchInput = dropdown.find('input[type="text"]');
                        if (searchInput.length) {
                            searchInput.val(''); // Clear search input if present
                            dropdown.find('.checkbox-options label').show(); // Show all options
                        }
                        applyFilters(); // Rerender table with updated filters
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Failed to fetch plan data:', error);
                    alert('Failed to load plan data. Using fallback unit options.');
                    $('#orderTableBody').html(`
                        <tr>
                            <td colspan="12" class="text-center text-danger fw-bold py-4">
                                Failed to load data.
                            </td>
                        </tr>
                    `);
                    renderTable(originalPlanData, $('#aggregatedView').is(':checked'), unitOptions);
                }
            });
        });
    </script>


    <script>
       $(document).ready(function () {
            monthwisedetails();
        });

        $('#TypeToggle').on('change', function() {
            let capacitytype = $(this).is(':checked') ? 'Machine' : 'Strength';
            monthwisedetails(capacitytype); // For capacityTable
            fetchPlanData(capacitytype);    // For orderTable
            $('#selectedMonthText').html('');
        });

        function formatNumber(num) {
            return (num / 100000).toFixed(2); // Convert to lakhs, 2 decimal places
        }

        function getBadgeColor(percentage) {
            if (percentage < 75) return 'red';
            if (percentage >= 75 && percentage < 90) return 'yellow';
            if (percentage >= 90 && percentage <= 120) return 'green';
            return 'purple';
        }

        function monthwisedetails(capacitytype) {
            $("#capacitySpinner").show();
           
            $.ajax({
                url: '{{ route("monthwisecapacity") }}',
                type: 'GET',
                data: { capacitytype: capacitytype },
                success: function(response) {
                    if (!response.success || !response.data || response.data.length === 0) {
                        $('#capacityTable').html('<tr><td colspan="100">No data available</td></tr>');
                        return;
                    }

                    // Transform data
                    const months = [...new Set(response.data.map(item => item.Ship_month))].map(month => {
                        const [mmm, yyyy] = month.split('-');
                        return `${mmm.slice(0, 3)}-${yyyy.slice(-2)}`;
                    });

                    const grouped = response.data.reduce((acc, item) => {
                        const unit = item.Unit;
                        const monthKey = `${item.Ship_month.split('-')[0].slice(0, 3)}-${item.Ship_month.split('-')[1].slice(-2)}`;
                        if (!acc[unit]) acc[unit] = {};
                        acc[unit][monthKey] = {
                            used: parseFloat(item.Booked_Mins) || 0,
                            avail: parseFloat(item.Unit_Capacity) || 0,
                            unit: item.Unit_Code,
                            month: item.Ship_month,
                            util: parseFloat(item.Bkd_Perc) || 0
                        };
                        return acc;
                    }, {});

                    const totals = months.reduce((acc, month) => {
                        const monthFull = response.data.find(item => {
                            const shortMonth = `${item.Ship_month.split('-')[0].slice(0, 3)}-${item.Ship_month.split('-')[1].slice(-2)}`;
                            return shortMonth === month;
                        }).Ship_month;
                        const monthData = response.data.filter(item => item.Ship_month === monthFull);
                        acc[month] = {
                            used: monthData.reduce((sum, item) => sum + (parseFloat(item.Booked_Mins) || 0), 0),
                            avail: monthData.reduce((sum, item) => sum + (parseFloat(item.Unit_Capacity) || 0), 0)
                        };
                        return acc;
                    }, {});

                    // Generate header
                    let thead = `
                        <tr>
                            <th>
                                <div>Factory</div>
                                <div><span class="text-danger" style="font-size: 0.7rem;">(Mins In Lakhs)</span></div>
                            </th>
                            ${months.map(month => `<th>${month}</th>`).join('')}
                            <th>Total</th>
                        </tr>
                    `;
                    $('#capacityTable thead').html(thead);

                    // Generate body
                    let tbody = '';
                    let factoryTotalUsed = {};
                    let factoryTotalAvail = {};
                    let factoryTotalUtil = {};

                    // Initialize totals
                    Object.keys(grouped).forEach(factory => {
                        factoryTotalUsed[factory] = 0;
                        factoryTotalAvail[factory] = 0;
                    });

                    // Factory rows
                    Object.keys(grouped).forEach(factory => {
                        let row = `<tr><td class="bg-light fw-bold">${factory}</td>`;
                        let factoryData = grouped[factory];

                        months.forEach(month => {
                            let data = factoryData[month] || { used: 0, avail: 0, unit: '', month: '', util: 0 };
                            let usedLabel = formatNumber(data.used);
                            let availLabel = formatNumber(data.avail);
                            let util = data.util.toFixed(1);
                            let badgeColor = getBadgeColor(parseFloat(util));

                            row += `
                                <td class="p-2 align-middle cap-month-cell" data-factory="${data.unit}" data-month="${data.month}">
                                    <div class="fw-semibold text-dark mb-1">${usedLabel} / ${availLabel}</div>
                                    <div style="text-align: center;">
                                        <span class="badge-text ${badgeColor}">${util}%</span>
                                    </div>
                                </td>
                            `;

                            factoryTotalUsed[factory] += data.used;
                            factoryTotalAvail[factory] += data.avail;
                        });

                        // Factory total cell
                        let totalUsedLabel = formatNumber(factoryTotalUsed[factory]);
                        let totalAvailLabel = formatNumber(factoryTotalAvail[factory]);
                        let totalUtil = factoryTotalAvail[factory] ? ((factoryTotalUsed[factory] / factoryTotalAvail[factory]) * 100).toFixed(1) : 0;
                        let totalBadgeColor = getBadgeColor(parseFloat(totalUtil));

                        row += `
                            <td class="p-2 align-middle cap-month-cell" data-factory="${factoryData[months[0]].unit}" data-month="overall">
                                <div class="fw-semibold text-dark mb-1">${totalUsedLabel} / ${totalAvailLabel}</div>
                                <div style="text-align: center;">
                                    <span class="badge-text ${totalBadgeColor}">${totalUtil}%</span>
                                </div>
                            </td>
                        `;
                        row += '</tr>';
                        tbody += row;
                    });

                    // Total row
                    let totalRow = '<tr><td class="bg-light fw-bold">Total</td>';
                    let grandTotalUsed = 0;
                    let grandTotalAvail = 0;

                    months.forEach(month => {
                        let totalData = totals[month] || { used: 0, avail: 0 };
                        let usedLabel = formatNumber(totalData.used);
                        let availLabel = formatNumber(totalData.avail);
                        let util = totalData.avail ? ((totalData.used / totalData.avail) * 100).toFixed(1) : 0;
                        let badgeColor = getBadgeColor(parseFloat(util));

                        totalRow += `
                            <td class="p-2 align-middle cap-month-cell" data-factory="" data-month="${grouped[Object.keys(grouped)[0]][month].month}">
                                <div class="fw-semibold text-dark mb-1">${usedLabel} / ${availLabel}</div>
                                <div style="text-align: center;">
                                    <span class="badge-text ${badgeColor}">${util}%</span>
                                </div>
                            </td>
                        `;

                        grandTotalUsed += totalData.used;
                        grandTotalAvail += totalData.avail;
                    });

                    // Grand total cell
                    let grandTotalUsedLabel = formatNumber(grandTotalUsed);
                    let grandTotalAvailLabel = formatNumber(grandTotalAvail);
                    let grandTotalUtil = grandTotalAvail ? ((grandTotalUsed / grandTotalAvail) * 100).toFixed(1) : 0;
                    let grandTotalBadgeColor = getBadgeColor(parseFloat(grandTotalUtil));

                    totalRow += `
                        <td class="p-2 align-middle cap-total-cell" data-factory="" style="cursor: pointer;">
                            <div class="fw-semibold text-dark mb-1" id="capoverall">${grandTotalUsedLabel} / ${grandTotalAvailLabel}</div>
                            <div style="text-align: center;">
                                <span class="badge-text ${grandTotalBadgeColor}">${grandTotalUtil}%</span>
                            </div>
                        </td>
                    `;
                    totalRow += '</tr>';
                    tbody += totalRow;

                    $('#capacityTableBody').html(tbody);
                    $("#capacitySpinner").hide();
                    
                },
                error: function(xhr, status, error) {
                    $("#capacitySpinner").hide();
                  
                    $('#capacityTable').html('<tr><td colspan="100">Error loading data</td></tr>');
                    console.error('AJAX error:', error);
                }
            });
        }

        document.addEventListener('click', () => {
            fetch('/check-session')
                .then(response => response.json())
                .then(data => {
                    if (!data.active) {
                        //alert("⚠️ Your session has timed out.");
                        toastr.warning('⚠️ Your session has timed out.');
                        setTimeout(() => {
                            window.location.href = "/login";
                        }, 3000);
                    }
                })
                .catch(err => {
                    console.error('Session check failed:', err);
                });
        });

        document.addEventListener('contextmenu', function(event) {
            event.preventDefault();
            
        });
    </script>
</body>
</html>